/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.IntegrationInstructions: ImageVector
    get() {
        if (_integrationInstructions != null) {
            return _integrationInstructions!!
        }
        _integrationInstructions = materialIcon(name = "Sharp.IntegrationInstructions") {
            materialPath {
                moveTo(21.0f, 3.0f)
                horizontalLineToRelative(-6.18f)
                curveTo(14.4f, 1.84f, 13.3f, 1.0f, 12.0f, 1.0f)
                reflectiveCurveTo(9.6f, 1.84f, 9.18f, 3.0f)
                horizontalLineTo(3.0f)
                verticalLineToRelative(18.0f)
                horizontalLineToRelative(18.0f)
                verticalLineTo(3.0f)
                close()
                moveTo(11.0f, 14.17f)
                lineToRelative(-1.41f, 1.42f)
                lineTo(6.0f, 12.0f)
                lineToRelative(3.59f, -3.59f)
                lineTo(11.0f, 9.83f)
                lineTo(8.83f, 12.0f)
                lineTo(11.0f, 14.17f)
                close()
                moveTo(12.0f, 4.25f)
                curveToRelative(-0.41f, 0.0f, -0.75f, -0.34f, -0.75f, -0.75f)
                reflectiveCurveTo(11.59f, 2.75f, 12.0f, 2.75f)
                reflectiveCurveToRelative(0.75f, 0.34f, 0.75f, 0.75f)
                reflectiveCurveTo(12.41f, 4.25f, 12.0f, 4.25f)
                close()
                moveTo(14.41f, 15.59f)
                lineTo(13.0f, 14.17f)
                lineTo(15.17f, 12.0f)
                lineTo(13.0f, 9.83f)
                lineToRelative(1.41f, -1.42f)
                lineTo(18.0f, 12.0f)
                lineTo(14.41f, 15.59f)
                close()
            }
        }
        return _integrationInstructions!!
    }

private var _integrationInstructions: ImageVector? = null
