/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.CarRental: ImageVector
    get() {
        if (_carRental != null) {
            return _carRental!!
        }
        _carRental = materialIcon(name = "Rounded.CarRental") {
            materialPath {
                moveTo(8.0f, 7.0f)
                curveToRelative(1.3f, 0.0f, 2.41f, -0.84f, 2.83f, -2.0f)
                horizontalLineTo(16.0f)
                verticalLineToRelative(1.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                reflectiveCurveToRelative(1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                reflectiveCurveToRelative(-0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-7.17f)
                curveTo(10.35f, 1.65f, 8.95f, 0.76f, 7.4f, 1.06f)
                curveTo(6.23f, 1.29f, 5.28f, 2.25f, 5.05f, 3.42f)
                curveTo(4.7f, 5.32f, 6.15f, 7.0f, 8.0f, 7.0f)
                close()
                moveTo(8.0f, 3.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveTo(8.55f, 5.0f, 8.0f, 5.0f)
                reflectiveCurveTo(7.0f, 4.55f, 7.0f, 4.0f)
                reflectiveCurveTo(7.45f, 3.0f, 8.0f, 3.0f)
                close()
                moveTo(16.39f, 9.0f)
                horizontalLineTo(7.61f)
                curveTo(7.18f, 9.0f, 6.8f, 9.28f, 6.66f, 9.68f)
                lineTo(5.0f, 14.69f)
                verticalLineTo(21.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                reflectiveCurveToRelative(1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(1.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                reflectiveCurveToRelative(1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-6.31f)
                lineToRelative(-1.66f, -5.01f)
                curveTo(17.2f, 9.28f, 16.82f, 9.0f, 16.39f, 9.0f)
                close()
                moveTo(9.0f, 17.5f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveTo(9.55f, 17.5f, 9.0f, 17.5f)
                close()
                moveTo(15.0f, 17.5f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveTo(15.55f, 17.5f, 15.0f, 17.5f)
                close()
                moveTo(7.67f, 13.0f)
                lineToRelative(0.66f, -2.0f)
                horizontalLineToRelative(7.34f)
                lineToRelative(0.66f, 2.0f)
                horizontalLineTo(7.67f)
                close()
            }
        }
        return _carRental!!
    }

private var _carRental: ImageVector? = null
