/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.HourglassBottom: ImageVector
    get() {
        if (_hourglassBottom != null) {
            return _hourglassBottom!!
        }
        _hourglassBottom = materialIcon(name = "Rounded.HourglassBottom") {
            materialPath {
                moveTo(16.0f, 22.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineToRelative(-0.01f, -3.18f)
                curveToRelative(0.0f, -0.53f, -0.21f, -1.03f, -0.58f, -1.41f)
                lineTo(14.0f, 12.0f)
                lineToRelative(3.41f, -3.43f)
                curveToRelative(0.37f, -0.37f, 0.58f, -0.88f, 0.58f, -1.41f)
                lineTo(18.0f, 4.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineTo(8.0f)
                curveTo(6.9f, 2.0f, 6.0f, 2.9f, 6.0f, 4.0f)
                verticalLineToRelative(3.16f)
                curveTo(6.0f, 7.69f, 6.21f, 8.2f, 6.58f, 8.58f)
                lineTo(10.0f, 12.0f)
                lineToRelative(-3.41f, 3.4f)
                curveTo(6.21f, 15.78f, 6.0f, 16.29f, 6.0f, 16.82f)
                verticalLineTo(20.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineTo(16.0f)
                close()
                moveTo(8.0f, 7.09f)
                verticalLineTo(5.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(6.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(2.09f)
                curveToRelative(0.0f, 0.27f, -0.11f, 0.52f, -0.29f, 0.71f)
                lineTo(12.0f, 11.5f)
                lineTo(8.29f, 7.79f)
                curveTo(8.11f, 7.61f, 8.0f, 7.35f, 8.0f, 7.09f)
                close()
            }
        }
        return _hourglassBottom!!
    }

private var _hourglassBottom: ImageVector? = null
