/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.automirrored.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.AutoMirrored.Filled.LabelImportant: ImageVector
    get() {
        if (_labelImportant != null) {
            return _labelImportant!!
        }
        _labelImportant = materialIcon(name = "AutoMirrored.Filled.LabelImportant", autoMirror =
                true) {
            materialPath {
                moveTo(3.5f, 18.99f)
                lineToRelative(11.0f, 0.01f)
                curveToRelative(0.67f, 0.0f, 1.27f, -0.33f, 1.63f, -0.84f)
                lineTo(20.5f, 12.0f)
                lineToRelative(-4.37f, -6.16f)
                curveToRelative(-0.36f, -0.51f, -0.96f, -0.84f, -1.63f, -0.84f)
                lineToRelative(-11.0f, 0.01f)
                lineTo(8.34f, 12.0f)
                lineTo(3.5f, 18.99f)
                close()
            }
        }
        return _labelImportant!!
    }

private var _labelImportant: ImageVector? = null
