/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.EmojiTransportation: ImageVector
    get() {
        if (_emojiTransportation != null) {
            return _emojiTransportation!!
        }
        _emojiTransportation = materialIcon(name = "TwoTone.EmojiTransportation") {
            materialPath {
                moveTo(20.57f, 10.66f)
                curveTo(20.43f, 10.26f, 20.05f, 10.0f, 19.6f, 10.0f)
                horizontalLineToRelative(-7.19f)
                curveToRelative(-0.46f, 0.0f, -0.83f, 0.26f, -0.98f, 0.66f)
                lineTo(10.0f, 14.77f)
                lineToRelative(0.01f, 5.51f)
                curveToRelative(0.0f, 0.38f, 0.31f, 0.72f, 0.69f, 0.72f)
                horizontalLineToRelative(0.62f)
                curveTo(11.7f, 21.0f, 12.0f, 20.62f, 12.0f, 20.24f)
                verticalLineTo(19.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(1.24f)
                curveToRelative(0.0f, 0.38f, 0.31f, 0.76f, 0.69f, 0.76f)
                horizontalLineToRelative(0.61f)
                curveToRelative(0.38f, 0.0f, 0.69f, -0.34f, 0.69f, -0.72f)
                lineTo(22.0f, 18.91f)
                verticalLineToRelative(-4.14f)
                lineTo(20.57f, 10.66f)
                close()
                moveTo(12.41f, 11.0f)
                horizontalLineToRelative(7.19f)
                lineToRelative(1.03f, 3.0f)
                horizontalLineToRelative(-9.25f)
                lineTo(12.41f, 11.0f)
                close()
                moveTo(12.0f, 17.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveTo(12.55f, 17.0f, 12.0f, 17.0f)
                close()
                moveTo(20.0f, 17.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveTo(20.55f, 17.0f, 20.0f, 17.0f)
                close()
            }
            materialPath {
                moveTo(14.0f, 9.0f)
                lineToRelative(1.0f, 0.0f)
                lineToRelative(0.0f, -6.0f)
                lineToRelative(-8.0f, 0.0f)
                lineToRelative(0.0f, 5.0f)
                lineToRelative(-5.0f, 0.0f)
                lineToRelative(0.0f, 13.0f)
                lineToRelative(1.0f, 0.0f)
                lineToRelative(0.0f, -12.0f)
                lineToRelative(5.0f, 0.0f)
                lineToRelative(0.0f, -5.0f)
                lineToRelative(6.0f, 0.0f)
                close()
            }
            materialPath {
                moveTo(5.0f, 11.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(10.0f, 5.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(5.0f, 15.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(5.0f, 19.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
        }
        return _emojiTransportation!!
    }

private var _emojiTransportation: ImageVector? = null
