/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Wifi1Bar: ImageVector
    get() {
        if (_wifi1Bar != null) {
            return _wifi1Bar!!
        }
        _wifi1Bar = materialIcon(name = "Sharp.Wifi1Bar") {
            materialPath {
                moveTo(15.53f, 17.46f)
                lineTo(12.0f, 21.0f)
                lineToRelative(-3.53f, -3.54f)
                curveTo(9.37f, 16.56f, 10.62f, 16.0f, 12.0f, 16.0f)
                reflectiveCurveTo(14.63f, 16.56f, 15.53f, 17.46f)
                close()
            }
        }
        return _wifi1Bar!!
    }

private var _wifi1Bar: ImageVector? = null
