/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded._8kPlus: ImageVector
    get() {
        if (__8kPlus != null) {
            return __8kPlus!!
        }
        __8kPlus = materialIcon(name = "Rounded._8kPlus") {
            materialPath {
                moveTo(19.0f, 3.0f)
                horizontalLineTo(5.0f)
                curveTo(3.9f, 3.0f, 3.0f, 3.9f, 3.0f, 5.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(5.0f)
                curveTo(21.0f, 3.9f, 20.1f, 3.0f, 19.0f, 3.0f)
                close()
                moveTo(10.0f, 14.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineTo(7.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-4.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineTo(14.0f)
                close()
                moveTo(14.59f, 15.0f)
                curveToRelative(-0.22f, 0.0f, -0.42f, -0.1f, -0.55f, -0.27f)
                lineToRelative(-1.54f, -1.98f)
                verticalLineToRelative(1.55f)
                curveToRelative(0.0f, 0.39f, -0.31f, 0.7f, -0.7f, 0.7f)
                horizontalLineTo(11.7f)
                curveToRelative(-0.39f, 0.0f, -0.7f, -0.31f, -0.7f, -0.7f)
                verticalLineTo(9.7f)
                curveTo(11.0f, 9.31f, 11.31f, 9.0f, 11.7f, 9.0f)
                horizontalLineToRelative(0.09f)
                curveToRelative(0.39f, 0.0f, 0.7f, 0.31f, 0.7f, 0.7f)
                verticalLineToRelative(1.55f)
                lineToRelative(1.54f, -1.98f)
                curveTo(14.17f, 9.1f, 14.38f, 9.0f, 14.59f, 9.0f)
                curveToRelative(0.58f, 0.0f, 0.91f, 0.66f, 0.56f, 1.12f)
                lineTo(13.75f, 12.0f)
                lineToRelative(1.41f, 1.88f)
                curveTo(15.5f, 14.34f, 15.17f, 15.0f, 14.59f, 15.0f)
                close()
                moveTo(19.0f, 12.5f)
                horizontalLineToRelative(-1.5f)
                verticalLineTo(14.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(-1.5f)
                horizontalLineTo(15.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(1.5f)
                verticalLineTo(10.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(1.5f)
                horizontalLineTo(19.0f)
                verticalLineTo(12.5f)
                close()
            }
            materialPath {
                moveTo(7.5f, 12.5f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(1.5f)
                horizontalLineToRelative(-1.0f)
                close()
            }
            materialPath {
                moveTo(7.5f, 10.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(1.5f)
                horizontalLineToRelative(-1.0f)
                close()
            }
        }
        return __8kPlus!!
    }

private var __8kPlus: ImageVector? = null
