/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.KeyboardControlKey: ImageVector
    get() {
        if (_keyboardControlKey != null) {
            return _keyboardControlKey!!
        }
        _keyboardControlKey = materialIcon(name = "Rounded.KeyboardControlKey") {
            materialPath {
                moveTo(5.71f, 12.71f)
                lineTo(5.71f, 12.71f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineTo(12.0f, 7.83f)
                lineToRelative(4.88f, 4.88f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineToRelative(-5.59f, -5.59f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineToRelative(-5.59f, 5.59f)
                curveTo(5.32f, 11.68f, 5.32f, 12.32f, 5.71f, 12.71f)
                close()
            }
        }
        return _keyboardControlKey!!
    }

private var _keyboardControlKey: ImageVector? = null
