/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Call: ImageVector
    get() {
        if (_call != null) {
            return _call!!
        }
        _call = materialIcon(name = "Filled.Call") {
            materialPath {
                moveTo(20.01f, 15.38f)
                curveToRelative(-1.23f, 0.0f, -2.42f, -0.2f, -3.53f, -0.56f)
                curveToRelative(-0.35f, -0.12f, -0.74f, -0.03f, -1.01f, 0.24f)
                lineToRelative(-1.57f, 1.97f)
                curveToRelative(-2.83f, -1.35f, -5.48f, -3.9f, -6.89f, -6.83f)
                lineToRelative(1.95f, -1.66f)
                curveToRelative(0.27f, -0.28f, 0.35f, -0.67f, 0.24f, -1.02f)
                curveToRelative(-0.37f, -1.11f, -0.56f, -2.3f, -0.56f, -3.53f)
                curveToRelative(0.0f, -0.54f, -0.45f, -0.99f, -0.99f, -0.99f)
                horizontalLineTo(4.19f)
                curveTo(3.65f, 3.0f, 3.0f, 3.24f, 3.0f, 3.99f)
                curveTo(3.0f, 13.28f, 10.73f, 21.0f, 20.01f, 21.0f)
                curveToRelative(0.71f, 0.0f, 0.99f, -0.63f, 0.99f, -1.18f)
                verticalLineToRelative(-3.45f)
                curveToRelative(0.0f, -0.54f, -0.45f, -0.99f, -0.99f, -0.99f)
                close()
            }
        }
        return _call!!
    }

private var _call: ImageVector? = null
