/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Settings: ImageVector
    get() {
        if (_settings != null) {
            return _settings!!
        }
        _settings = materialIcon(name = "TwoTone.Settings") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(19.28f, 8.6f)
                lineToRelative(-0.7f, -1.21f)
                lineToRelative(-1.27f, 0.51f)
                lineToRelative(-1.06f, 0.43f)
                lineToRelative(-0.91f, -0.7f)
                curveToRelative(-0.39f, -0.3f, -0.8f, -0.54f, -1.23f, -0.71f)
                lineToRelative(-1.06f, -0.43f)
                lineToRelative(-0.16f, -1.13f)
                lineTo(12.7f, 4.0f)
                horizontalLineToRelative(-1.4f)
                lineToRelative(-0.19f, 1.35f)
                lineToRelative(-0.16f, 1.13f)
                lineToRelative(-1.06f, 0.44f)
                curveToRelative(-0.41f, 0.17f, -0.82f, 0.41f, -1.25f, 0.73f)
                lineToRelative(-0.9f, 0.68f)
                lineToRelative(-1.05f, -0.42f)
                lineToRelative(-1.27f, -0.52f)
                lineToRelative(-0.7f, 1.21f)
                lineToRelative(1.08f, 0.84f)
                lineToRelative(0.89f, 0.7f)
                lineToRelative(-0.14f, 1.13f)
                curveToRelative(-0.03f, 0.3f, -0.05f, 0.53f, -0.05f, 0.73f)
                reflectiveCurveToRelative(0.02f, 0.43f, 0.05f, 0.73f)
                lineToRelative(0.14f, 1.13f)
                lineToRelative(-0.89f, 0.7f)
                lineToRelative(-1.08f, 0.84f)
                lineToRelative(0.7f, 1.21f)
                lineToRelative(1.27f, -0.51f)
                lineToRelative(1.06f, -0.43f)
                lineToRelative(0.91f, 0.7f)
                curveToRelative(0.39f, 0.3f, 0.8f, 0.54f, 1.23f, 0.71f)
                lineToRelative(1.06f, 0.43f)
                lineToRelative(0.16f, 1.13f)
                lineToRelative(0.19f, 1.36f)
                horizontalLineToRelative(1.39f)
                lineToRelative(0.19f, -1.35f)
                lineToRelative(0.16f, -1.13f)
                lineToRelative(1.06f, -0.43f)
                curveToRelative(0.41f, -0.17f, 0.82f, -0.41f, 1.25f, -0.73f)
                lineToRelative(0.9f, -0.68f)
                lineToRelative(1.04f, 0.42f)
                lineToRelative(1.27f, 0.51f)
                lineToRelative(0.7f, -1.21f)
                lineToRelative(-1.08f, -0.84f)
                lineToRelative(-0.89f, -0.7f)
                lineToRelative(0.14f, -1.13f)
                curveToRelative(0.04f, -0.31f, 0.05f, -0.52f, 0.05f, -0.73f)
                curveToRelative(0.0f, -0.21f, -0.02f, -0.43f, -0.05f, -0.73f)
                lineToRelative(-0.14f, -1.13f)
                lineToRelative(0.89f, -0.7f)
                lineToRelative(1.1f, -0.84f)
                close()
                moveTo(12.0f, 16.0f)
                curveToRelative(-2.21f, 0.0f, -4.0f, -1.79f, -4.0f, -4.0f)
                reflectiveCurveToRelative(1.79f, -4.0f, 4.0f, -4.0f)
                reflectiveCurveToRelative(4.0f, 1.79f, 4.0f, 4.0f)
                reflectiveCurveToRelative(-1.79f, 4.0f, -4.0f, 4.0f)
                close()
            }
            materialPath {
                moveTo(19.43f, 12.98f)
                curveToRelative(0.04f, -0.32f, 0.07f, -0.64f, 0.07f, -0.98f)
                curveToRelative(0.0f, -0.34f, -0.03f, -0.66f, -0.07f, -0.98f)
                lineToRelative(2.11f, -1.65f)
                curveToRelative(0.19f, -0.15f, 0.24f, -0.42f, 0.12f, -0.64f)
                lineToRelative(-2.0f, -3.46f)
                curveToRelative(-0.09f, -0.16f, -0.26f, -0.25f, -0.44f, -0.25f)
                curveToRelative(-0.06f, 0.0f, -0.12f, 0.01f, -0.17f, 0.03f)
                lineToRelative(-2.49f, 1.0f)
                curveToRelative(-0.52f, -0.4f, -1.08f, -0.73f, -1.69f, -0.98f)
                lineToRelative(-0.38f, -2.65f)
                curveTo(14.46f, 2.18f, 14.25f, 2.0f, 14.0f, 2.0f)
                horizontalLineToRelative(-4.0f)
                curveToRelative(-0.25f, 0.0f, -0.46f, 0.18f, -0.49f, 0.42f)
                lineToRelative(-0.38f, 2.65f)
                curveToRelative(-0.61f, 0.25f, -1.17f, 0.59f, -1.69f, 0.98f)
                lineToRelative(-2.49f, -1.0f)
                curveToRelative(-0.06f, -0.02f, -0.12f, -0.03f, -0.18f, -0.03f)
                curveToRelative(-0.17f, 0.0f, -0.34f, 0.09f, -0.43f, 0.25f)
                lineToRelative(-2.0f, 3.46f)
                curveToRelative(-0.13f, 0.22f, -0.07f, 0.49f, 0.12f, 0.64f)
                lineToRelative(2.11f, 1.65f)
                curveToRelative(-0.04f, 0.32f, -0.07f, 0.65f, -0.07f, 0.98f)
                reflectiveCurveToRelative(0.03f, 0.66f, 0.07f, 0.98f)
                lineToRelative(-2.11f, 1.65f)
                curveToRelative(-0.19f, 0.15f, -0.24f, 0.42f, -0.12f, 0.64f)
                lineToRelative(2.0f, 3.46f)
                curveToRelative(0.09f, 0.16f, 0.26f, 0.25f, 0.44f, 0.25f)
                curveToRelative(0.06f, 0.0f, 0.12f, -0.01f, 0.17f, -0.03f)
                lineToRelative(2.49f, -1.0f)
                curveToRelative(0.52f, 0.4f, 1.08f, 0.73f, 1.69f, 0.98f)
                lineToRelative(0.38f, 2.65f)
                curveToRelative(0.03f, 0.24f, 0.24f, 0.42f, 0.49f, 0.42f)
                horizontalLineToRelative(4.0f)
                curveToRelative(0.25f, 0.0f, 0.46f, -0.18f, 0.49f, -0.42f)
                lineToRelative(0.38f, -2.65f)
                curveToRelative(0.61f, -0.25f, 1.17f, -0.59f, 1.69f, -0.98f)
                lineToRelative(2.49f, 1.0f)
                curveToRelative(0.06f, 0.02f, 0.12f, 0.03f, 0.18f, 0.03f)
                curveToRelative(0.17f, 0.0f, 0.34f, -0.09f, 0.43f, -0.25f)
                lineToRelative(2.0f, -3.46f)
                curveToRelative(0.12f, -0.22f, 0.07f, -0.49f, -0.12f, -0.64f)
                lineToRelative(-2.11f, -1.65f)
                close()
                moveTo(17.45f, 11.27f)
                curveToRelative(0.04f, 0.31f, 0.05f, 0.52f, 0.05f, 0.73f)
                curveToRelative(0.0f, 0.21f, -0.02f, 0.43f, -0.05f, 0.73f)
                lineToRelative(-0.14f, 1.13f)
                lineToRelative(0.89f, 0.7f)
                lineToRelative(1.08f, 0.84f)
                lineToRelative(-0.7f, 1.21f)
                lineToRelative(-1.27f, -0.51f)
                lineToRelative(-1.04f, -0.42f)
                lineToRelative(-0.9f, 0.68f)
                curveToRelative(-0.43f, 0.32f, -0.84f, 0.56f, -1.25f, 0.73f)
                lineToRelative(-1.06f, 0.43f)
                lineToRelative(-0.16f, 1.13f)
                lineToRelative(-0.2f, 1.35f)
                horizontalLineToRelative(-1.4f)
                lineToRelative(-0.19f, -1.35f)
                lineToRelative(-0.16f, -1.13f)
                lineToRelative(-1.06f, -0.43f)
                curveToRelative(-0.43f, -0.18f, -0.83f, -0.41f, -1.23f, -0.71f)
                lineToRelative(-0.91f, -0.7f)
                lineToRelative(-1.06f, 0.43f)
                lineToRelative(-1.27f, 0.51f)
                lineToRelative(-0.7f, -1.21f)
                lineToRelative(1.08f, -0.84f)
                lineToRelative(0.89f, -0.7f)
                lineToRelative(-0.14f, -1.13f)
                curveToRelative(-0.03f, -0.31f, -0.05f, -0.54f, -0.05f, -0.74f)
                reflectiveCurveToRelative(0.02f, -0.43f, 0.05f, -0.73f)
                lineToRelative(0.14f, -1.13f)
                lineToRelative(-0.89f, -0.7f)
                lineToRelative(-1.08f, -0.84f)
                lineToRelative(0.7f, -1.21f)
                lineToRelative(1.27f, 0.51f)
                lineToRelative(1.04f, 0.42f)
                lineToRelative(0.9f, -0.68f)
                curveToRelative(0.43f, -0.32f, 0.84f, -0.56f, 1.25f, -0.73f)
                lineToRelative(1.06f, -0.43f)
                lineToRelative(0.16f, -1.13f)
                lineToRelative(0.2f, -1.35f)
                horizontalLineToRelative(1.39f)
                lineToRelative(0.19f, 1.35f)
                lineToRelative(0.16f, 1.13f)
                lineToRelative(1.06f, 0.43f)
                curveToRelative(0.43f, 0.18f, 0.83f, 0.41f, 1.23f, 0.71f)
                lineToRelative(0.91f, 0.7f)
                lineToRelative(1.06f, -0.43f)
                lineToRelative(1.27f, -0.51f)
                lineToRelative(0.7f, 1.21f)
                lineToRelative(-1.07f, 0.85f)
                lineToRelative(-0.89f, 0.7f)
                lineToRelative(0.14f, 1.13f)
                close()
                moveTo(12.0f, 8.0f)
                curveToRelative(-2.21f, 0.0f, -4.0f, 1.79f, -4.0f, 4.0f)
                reflectiveCurveToRelative(1.79f, 4.0f, 4.0f, 4.0f)
                reflectiveCurveToRelative(4.0f, -1.79f, 4.0f, -4.0f)
                reflectiveCurveToRelative(-1.79f, -4.0f, -4.0f, -4.0f)
                close()
                moveTo(12.0f, 14.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                reflectiveCurveToRelative(0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                reflectiveCurveToRelative(-0.9f, 2.0f, -2.0f, 2.0f)
                close()
            }
        }
        return _settings!!
    }

private var _settings: ImageVector? = null
