/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Face: ImageVector
    get() {
        if (_face != null) {
            return _face!!
        }
        _face = materialIcon(name = "Rounded.Face") {
            materialPath {
                moveTo(10.25f, 13.0f)
                curveToRelative(0.0f, 0.69f, -0.56f, 1.25f, -1.25f, 1.25f)
                reflectiveCurveTo(7.75f, 13.69f, 7.75f, 13.0f)
                reflectiveCurveTo(8.31f, 11.75f, 9.0f, 11.75f)
                reflectiveCurveTo(10.25f, 12.31f, 10.25f, 13.0f)
                close()
                moveTo(15.0f, 11.75f)
                curveToRelative(-0.69f, 0.0f, -1.25f, 0.56f, -1.25f, 1.25f)
                reflectiveCurveToRelative(0.56f, 1.25f, 1.25f, 1.25f)
                reflectiveCurveToRelative(1.25f, -0.56f, 1.25f, -1.25f)
                reflectiveCurveTo(15.69f, 11.75f, 15.0f, 11.75f)
                close()
                moveTo(22.0f, 12.0f)
                curveToRelative(0.0f, 5.52f, -4.48f, 10.0f, -10.0f, 10.0f)
                reflectiveCurveTo(2.0f, 17.52f, 2.0f, 12.0f)
                reflectiveCurveTo(6.48f, 2.0f, 12.0f, 2.0f)
                reflectiveCurveTo(22.0f, 6.48f, 22.0f, 12.0f)
                close()
                moveTo(20.0f, 12.0f)
                curveToRelative(0.0f, -0.78f, -0.12f, -1.53f, -0.33f, -2.24f)
                curveTo(18.97f, 9.91f, 18.25f, 10.0f, 17.5f, 10.0f)
                curveToRelative(-3.13f, 0.0f, -5.92f, -1.44f, -7.76f, -3.69f)
                curveTo(8.69f, 8.87f, 6.6f, 10.88f, 4.0f, 11.86f)
                curveTo(4.01f, 11.9f, 4.0f, 11.95f, 4.0f, 12.0f)
                curveToRelative(0.0f, 4.41f, 3.59f, 8.0f, 8.0f, 8.0f)
                reflectiveCurveTo(20.0f, 16.41f, 20.0f, 12.0f)
                close()
            }
        }
        return _face!!
    }

private var _face: ImageVector? = null
