/*
 * Copyright 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Call: ImageVector
    get() {
        if (_call != null) {
            return _call!!
        }
        _call = materialIcon(name = "Rounded.Call") {
            materialPath {
                moveTo(15.63f, 14.4f)
                lineToRelative(-2.52f, 2.5f)
                curveToRelative(-2.5f, -1.43f, -4.57f, -3.5f, -6.0f, -6.0f)
                lineToRelative(2.5f, -2.52f)
                curveToRelative(0.23f, -0.24f, 0.33f, -0.57f, 0.27f, -0.9f)
                lineTo(9.13f, 3.8f)
                curveTo(9.04f, 3.34f, 8.63f, 3.0f, 8.15f, 3.0f)
                lineTo(4.0f, 3.0f)
                curveTo(3.44f, 3.0f, 2.97f, 3.47f, 3.0f, 4.03f)
                curveTo(3.17f, 6.92f, 4.05f, 9.63f, 5.43f, 12.0f)
                curveToRelative(1.58f, 2.73f, 3.85f, 4.99f, 6.57f, 6.57f)
                curveToRelative(2.37f, 1.37f, 5.08f, 2.26f, 7.97f, 2.43f)
                curveToRelative(0.56f, 0.03f, 1.03f, -0.44f, 1.03f, -1.0f)
                lineToRelative(0.0f, -4.15f)
                curveToRelative(0.0f, -0.48f, -0.34f, -0.89f, -0.8f, -0.98f)
                lineToRelative(-3.67f, -0.73f)
                curveTo(16.2f, 14.07f, 15.86f, 14.17f, 15.63f, 14.4f)
                close()
            }
        }
        return _call!!
    }

private var _call: ImageVector? = null
