/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.graphics.vector;

import androidx.compose.runtime.State;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.SolidColor;
import androidx.compose.ui.graphics.vector.PathNode;
import androidx.compose.ui.graphics.vector.VectorConfig;
import androidx.compose.ui.graphics.vector.VectorProperty;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b,\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010:\u001a\u0002H;\"\u0004\b\u0000\u0010;2\f\u0010<\u001a\b\u0012\u0004\u0012\u0002H;0=2\u0006\u0010>\u001a\u0002H;H\u0016\u00a2\u0006\u0002\u0010?R\"\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR%\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0004X\u0086\u000e\u00f8\u0001\u0000\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u0007\"\u0004\b\r\u0010\tR(\u0010\u000e\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR\"\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0007\"\u0004\b\u0015\u0010\tR\"\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0007\"\u0004\b\u0018\u0010\tR\"\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0007\"\u0004\b\u001b\u0010\tR\"\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0007\"\u0004\b\u001e\u0010\tR\"\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0007\"\u0004\b!\u0010\tR\"\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0007\"\u0004\b$\u0010\tR%\u0010%\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0004X\u0086\u000e\u00f8\u0001\u0000\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0007\"\u0004\b'\u0010\tR\"\u0010(\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0007\"\u0004\b*\u0010\tR\"\u0010+\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0007\"\u0004\b-\u0010\tR\"\u0010.\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0007\"\u0004\b0\u0010\tR\"\u00101\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u0007\"\u0004\b3\u0010\tR\"\u00104\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u0007\"\u0004\b6\u0010\tR\"\u00107\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\u0007\"\u0004\b9\u0010\t\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006@"}, d2={"Landroidx/compose/animation/graphics/vector/StateVectorConfig;", "Landroidx/compose/ui/graphics/vector/VectorConfig;", "()V", "fillAlphaState", "Landroidx/compose/runtime/State;", "", "getFillAlphaState", "()Landroidx/compose/runtime/State;", "setFillAlphaState", "(Landroidx/compose/runtime/State;)V", "fillColorState", "Landroidx/compose/ui/graphics/Color;", "getFillColorState", "setFillColorState", "pathDataState", "", "Landroidx/compose/ui/graphics/vector/PathNode;", "getPathDataState", "setPathDataState", "pivotXState", "getPivotXState", "setPivotXState", "pivotYState", "getPivotYState", "setPivotYState", "rotationState", "getRotationState", "setRotationState", "scaleXState", "getScaleXState", "setScaleXState", "scaleYState", "getScaleYState", "setScaleYState", "strokeAlphaState", "getStrokeAlphaState", "setStrokeAlphaState", "strokeColorState", "getStrokeColorState", "setStrokeColorState", "strokeWidthState", "getStrokeWidthState", "setStrokeWidthState", "translateXState", "getTranslateXState", "setTranslateXState", "translateYState", "getTranslateYState", "setTranslateYState", "trimPathEndState", "getTrimPathEndState", "setTrimPathEndState", "trimPathOffsetState", "getTrimPathOffsetState", "setTrimPathOffsetState", "trimPathStartState", "getTrimPathStartState", "setTrimPathStartState", "getOrDefault", "T", "property", "Landroidx/compose/ui/graphics/vector/VectorProperty;", "defaultValue", "(Landroidx/compose/ui/graphics/vector/VectorProperty;Ljava/lang/Object;)Ljava/lang/Object;", "animation-graphics_release"})
public final class StateVectorConfig
implements VectorConfig {
    @Nullable
    private State<Float> rotationState;
    @Nullable
    private State<Float> pivotXState;
    @Nullable
    private State<Float> pivotYState;
    @Nullable
    private State<Float> scaleXState;
    @Nullable
    private State<Float> scaleYState;
    @Nullable
    private State<Float> translateXState;
    @Nullable
    private State<Float> translateYState;
    @Nullable
    private State<? extends List<? extends PathNode>> pathDataState;
    @Nullable
    private State<Color> fillColorState;
    @Nullable
    private State<Color> strokeColorState;
    @Nullable
    private State<Float> strokeWidthState;
    @Nullable
    private State<Float> strokeAlphaState;
    @Nullable
    private State<Float> fillAlphaState;
    @Nullable
    private State<Float> trimPathStartState;
    @Nullable
    private State<Float> trimPathEndState;
    @Nullable
    private State<Float> trimPathOffsetState;

    @Nullable
    public final State<Float> getRotationState() {
        return this.rotationState;
    }

    public final void setRotationState(@Nullable State<Float> state) {
        this.rotationState = state;
    }

    @Nullable
    public final State<Float> getPivotXState() {
        return this.pivotXState;
    }

    public final void setPivotXState(@Nullable State<Float> state) {
        this.pivotXState = state;
    }

    @Nullable
    public final State<Float> getPivotYState() {
        return this.pivotYState;
    }

    public final void setPivotYState(@Nullable State<Float> state) {
        this.pivotYState = state;
    }

    @Nullable
    public final State<Float> getScaleXState() {
        return this.scaleXState;
    }

    public final void setScaleXState(@Nullable State<Float> state) {
        this.scaleXState = state;
    }

    @Nullable
    public final State<Float> getScaleYState() {
        return this.scaleYState;
    }

    public final void setScaleYState(@Nullable State<Float> state) {
        this.scaleYState = state;
    }

    @Nullable
    public final State<Float> getTranslateXState() {
        return this.translateXState;
    }

    public final void setTranslateXState(@Nullable State<Float> state) {
        this.translateXState = state;
    }

    @Nullable
    public final State<Float> getTranslateYState() {
        return this.translateYState;
    }

    public final void setTranslateYState(@Nullable State<Float> state) {
        this.translateYState = state;
    }

    @Nullable
    public final State<List<PathNode>> getPathDataState() {
        return this.pathDataState;
    }

    public final void setPathDataState(@Nullable State<? extends List<? extends PathNode>> state) {
        this.pathDataState = state;
    }

    @Nullable
    public final State<Color> getFillColorState() {
        return this.fillColorState;
    }

    public final void setFillColorState(@Nullable State<Color> state) {
        this.fillColorState = state;
    }

    @Nullable
    public final State<Color> getStrokeColorState() {
        return this.strokeColorState;
    }

    public final void setStrokeColorState(@Nullable State<Color> state) {
        this.strokeColorState = state;
    }

    @Nullable
    public final State<Float> getStrokeWidthState() {
        return this.strokeWidthState;
    }

    public final void setStrokeWidthState(@Nullable State<Float> state) {
        this.strokeWidthState = state;
    }

    @Nullable
    public final State<Float> getStrokeAlphaState() {
        return this.strokeAlphaState;
    }

    public final void setStrokeAlphaState(@Nullable State<Float> state) {
        this.strokeAlphaState = state;
    }

    @Nullable
    public final State<Float> getFillAlphaState() {
        return this.fillAlphaState;
    }

    public final void setFillAlphaState(@Nullable State<Float> state) {
        this.fillAlphaState = state;
    }

    @Nullable
    public final State<Float> getTrimPathStartState() {
        return this.trimPathStartState;
    }

    public final void setTrimPathStartState(@Nullable State<Float> state) {
        this.trimPathStartState = state;
    }

    @Nullable
    public final State<Float> getTrimPathEndState() {
        return this.trimPathEndState;
    }

    public final void setTrimPathEndState(@Nullable State<Float> state) {
        this.trimPathEndState = state;
    }

    @Nullable
    public final State<Float> getTrimPathOffsetState() {
        return this.trimPathOffsetState;
    }

    public final void setTrimPathOffsetState(@Nullable State<Float> state) {
        this.trimPathOffsetState = state;
    }

    public <T> T getOrDefault(@NotNull VectorProperty<T> property, T defaultValue) {
        Object object;
        Intrinsics.checkNotNullParameter(property, (String)"property");
        VectorProperty<T> vectorProperty = property;
        if (vectorProperty instanceof VectorProperty.Rotation) {
            State<Float> state = this.rotationState;
            object = state != null ? Float.valueOf(((Number)state.getValue()).floatValue()) : defaultValue;
        } else if (vectorProperty instanceof VectorProperty.PivotX) {
            State<Float> state = this.pivotXState;
            object = state != null ? Float.valueOf(((Number)state.getValue()).floatValue()) : defaultValue;
        } else if (vectorProperty instanceof VectorProperty.PivotY) {
            State<Float> state = this.pivotYState;
            object = state != null ? Float.valueOf(((Number)state.getValue()).floatValue()) : defaultValue;
        } else if (vectorProperty instanceof VectorProperty.ScaleX) {
            State<Float> state = this.scaleXState;
            object = state != null ? Float.valueOf(((Number)state.getValue()).floatValue()) : defaultValue;
        } else if (vectorProperty instanceof VectorProperty.ScaleY) {
            State<Float> state = this.scaleYState;
            object = state != null ? Float.valueOf(((Number)state.getValue()).floatValue()) : defaultValue;
        } else if (vectorProperty instanceof VectorProperty.TranslateX) {
            State<Float> state = this.translateXState;
            object = state != null ? Float.valueOf(((Number)state.getValue()).floatValue()) : defaultValue;
        } else if (vectorProperty instanceof VectorProperty.TranslateY) {
            State<Float> state = this.translateYState;
            object = state != null ? Float.valueOf(((Number)state.getValue()).floatValue()) : defaultValue;
        } else if (vectorProperty instanceof VectorProperty.PathData) {
            object = this.pathDataState;
            if (object == null || (object = (List)object.getValue()) == null) {
                object = defaultValue;
            }
        } else if (vectorProperty instanceof VectorProperty.Fill) {
            State<Color> state = this.fillColorState;
            if (state != null) {
                State<Color> state2 = state;
                boolean bl = false;
                object = new SolidColor(((Color)state2.getValue()).unbox-impl(), null);
            } else {
                object = defaultValue;
            }
        } else if (vectorProperty instanceof VectorProperty.FillAlpha) {
            State<Float> state = this.fillAlphaState;
            object = state != null ? Float.valueOf(((Number)state.getValue()).floatValue()) : defaultValue;
        } else if (vectorProperty instanceof VectorProperty.Stroke) {
            State<Color> state = this.strokeColorState;
            if (state != null) {
                State<Color> state3 = state;
                boolean bl = false;
                object = new SolidColor(((Color)state3.getValue()).unbox-impl(), null);
            } else {
                object = defaultValue;
            }
        } else if (vectorProperty instanceof VectorProperty.StrokeLineWidth) {
            State<Float> state = this.strokeWidthState;
            object = state != null ? Float.valueOf(((Number)state.getValue()).floatValue()) : defaultValue;
        } else if (vectorProperty instanceof VectorProperty.StrokeAlpha) {
            State<Float> state = this.strokeAlphaState;
            object = state != null ? Float.valueOf(((Number)state.getValue()).floatValue()) : defaultValue;
        } else if (vectorProperty instanceof VectorProperty.TrimPathStart) {
            State<Float> state = this.trimPathStartState;
            object = state != null ? Float.valueOf(((Number)state.getValue()).floatValue()) : defaultValue;
        } else if (vectorProperty instanceof VectorProperty.TrimPathEnd) {
            State<Float> state = this.trimPathEndState;
            object = state != null ? Float.valueOf(((Number)state.getValue()).floatValue()) : defaultValue;
        } else if (vectorProperty instanceof VectorProperty.TrimPathOffset) {
            State<Float> state = this.trimPathOffsetState;
            object = state != null ? Float.valueOf(((Number)state.getValue()).floatValue()) : defaultValue;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }
}

