/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.FloatAnimationSpec;
import androidx.compose.animation.core.Motion;
import androidx.compose.animation.core.SpringEstimationKt;
import androidx.compose.animation.core.SpringSimulation;
import androidx.compose.animation.core.TwoWayConverter;
import androidx.compose.animation.core.VectorizedFloatAnimationSpec;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J \u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J(\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J(\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Landroidx/compose/animation/core/FloatSpringSpec;", "Landroidx/compose/animation/core/FloatAnimationSpec;", "dampingRatio", "", "stiffness", "visibilityThreshold", "(FFF)V", "getDampingRatio", "()F", "spring", "Landroidx/compose/animation/core/SpringSimulation;", "getStiffness", "getDurationNanos", "", "initialValue", "targetValue", "initialVelocity", "getEndVelocity", "getValueFromNanos", "playTimeNanos", "getVelocityFromNanos", "animation-core_release"})
@StabilityInferred(parameters=0)
public final class FloatSpringSpec
implements FloatAnimationSpec {
    private final float dampingRatio;
    private final float stiffness;
    private final float visibilityThreshold;
    @NotNull
    private final SpringSimulation spring;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public FloatSpringSpec(float dampingRatio, float stiffness, float visibilityThreshold) {
        void it;
        SpringSimulation springSimulation;
        this.dampingRatio = dampingRatio;
        this.stiffness = stiffness;
        this.visibilityThreshold = visibilityThreshold;
        SpringSimulation springSimulation2 = springSimulation = new SpringSimulation(1.0f);
        FloatSpringSpec floatSpringSpec = this;
        boolean bl = false;
        it.setDampingRatio(this.dampingRatio);
        it.setStiffness(this.stiffness);
        floatSpringSpec.spring = springSimulation;
    }

    public /* synthetic */ FloatSpringSpec(float f, float f2, float f3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 1.0f;
        }
        if ((n & 2) != 0) {
            f2 = 1500.0f;
        }
        if ((n & 4) != 0) {
            f3 = 0.01f;
        }
        this(f, f2, f3);
    }

    public final float getDampingRatio() {
        return this.dampingRatio;
    }

    public final float getStiffness() {
        return this.stiffness;
    }

    @Override
    public float getValueFromNanos(long playTimeNanos, float initialValue, float targetValue, float initialVelocity) {
        long playTimeMillis = playTimeNanos / 1000000L;
        this.spring.setFinalPosition(targetValue);
        float value = Motion.getValue-impl(this.spring.updateValues-IJZedt4$animation_core_release(initialValue, initialVelocity, playTimeMillis));
        return value;
    }

    @Override
    public float getVelocityFromNanos(long playTimeNanos, float initialValue, float targetValue, float initialVelocity) {
        long playTimeMillis = playTimeNanos / 1000000L;
        this.spring.setFinalPosition(targetValue);
        float velocity = Motion.getVelocity-impl(this.spring.updateValues-IJZedt4$animation_core_release(initialValue, initialVelocity, playTimeMillis));
        return velocity;
    }

    @Override
    public float getEndVelocity(float initialValue, float targetValue, float initialVelocity) {
        return 0.0f;
    }

    @Override
    public long getDurationNanos(float initialValue, float targetValue, float initialVelocity) {
        float f = this.spring.getStiffness();
        float f2 = this.spring.getDampingRatio();
        float f3 = (initialValue - targetValue) / this.visibilityThreshold;
        float f4 = initialVelocity / this.visibilityThreshold;
        return SpringEstimationKt.estimateAnimationDurationMillis(f, f2, f4, f3, 1.0f) * 1000000L;
    }

    @Override
    @NotNull
    public <V extends AnimationVector> VectorizedFloatAnimationSpec<V> vectorize(@NotNull TwoWayConverter<Float, V> converter) {
        return FloatAnimationSpec.DefaultImpls.vectorize(this, converter);
    }

    public FloatSpringSpec() {
        this(0.0f, 0.0f, 0.0f, 7, null);
    }
}

