/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.EasingKt;
import androidx.compose.animation.core.FloatAnimationSpec;
import androidx.compose.animation.core.PropKeyKt;
import androidx.compose.animation.core.TwoWayConverter;
import androidx.compose.animation.core.VectorizedFloatAnimationSpec;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\b\u0018\u00002\u00020\u0001BB\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012'\b\u0002\u0010\u0005\u001a!\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J \u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007H\u0016J(\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007H\u0016J(\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR-\u0010\u0005\u001a!\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Landroidx/compose/animation/core/FloatTweenSpec;", "Landroidx/compose/animation/core/FloatAnimationSpec;", "duration", "", "delay", "easing", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "fraction", "Landroidx/compose/animation/core/Easing;", "(IILkotlin/jvm/functions/Function1;)V", "getDelay", "()I", "getDuration", "clampPlayTime", "", "playTime", "getDurationMillis", "start", "end", "startVelocity", "getValue", "getVelocity", "animation-core_release"})
public final class FloatTweenSpec
implements FloatAnimationSpec {
    private final int duration;
    private final int delay;
    private final Function1<Float, Float> easing;

    @Override
    public float getValue(long playTime, float start, float end, float startVelocity) {
        long clampedPlayTime = this.clampPlayTime(playTime);
        float rawFraction = this.duration == 0 ? 1.0f : (float)clampedPlayTime / (float)this.duration;
        float fraction = ((Number)this.easing.invoke((Object)Float.valueOf(RangesKt.coerceIn((float)rawFraction, (float)0.0f, (float)1.0f)))).floatValue();
        return PropKeyKt.lerp(start, end, fraction);
    }

    private final long clampPlayTime(long playTime) {
        return RangesKt.coerceIn((long)(playTime - (long)this.delay), (long)0L, (long)this.duration);
    }

    @Override
    public long getDurationMillis(float start, float end, float startVelocity) {
        return (long)this.delay + (long)this.duration;
    }

    @Override
    public float getVelocity(long playTime, float start, float end, float startVelocity) {
        long clampedPlayTime = this.clampPlayTime(playTime);
        if (clampedPlayTime < 0L) {
            return 0.0f;
        }
        if (clampedPlayTime == 0L) {
            return startVelocity;
        }
        float startNum = this.getValue(clampedPlayTime - 1L, start, end, startVelocity);
        float endNum = this.getValue(clampedPlayTime, start, end, startVelocity);
        return (endNum - startNum) * 1000.0f;
    }

    public final int getDuration() {
        return this.duration;
    }

    public final int getDelay() {
        return this.delay;
    }

    public FloatTweenSpec(int duration2, int delay, @NotNull Function1<? super Float, Float> easing) {
        Intrinsics.checkNotNullParameter(easing, (String)"easing");
        this.duration = duration2;
        this.delay = delay;
        this.easing = easing;
    }

    public /* synthetic */ FloatTweenSpec(int n, int n2, Function1 function1, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 300;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        if ((n3 & 4) != 0) {
            function1 = EasingKt.getFastOutSlowInEasing();
        }
        this(n, n2, (Function1<? super Float, Float>)function1);
    }

    public FloatTweenSpec() {
        this(0, 0, null, 7, null);
    }

    @Override
    public float getEndVelocity(float start, float end, float startVelocity) {
        return FloatAnimationSpec.DefaultImpls.getEndVelocity(this, start, end, startVelocity);
    }

    @Override
    @NotNull
    public <V extends AnimationVector> VectorizedFloatAnimationSpec<V> vectorize(@NotNull TwoWayConverter<Float, V> converter) {
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        return FloatAnimationSpec.DefaultImpls.vectorize(this, converter);
    }
}

