/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.annotation.FloatRange;
import androidx.compose.animation.core.FloatDecayAnimationSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0003\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0018\u0010\r\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0016J \u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0016J \u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0016R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Landroidx/compose/animation/core/ExponentialDecay;", "Landroidx/compose/animation/core/FloatDecayAnimationSpec;", "frictionMultiplier", "", "absVelocityThreshold", "(FF)V", "getAbsVelocityThreshold", "()F", "friction", "getDurationMillis", "", "start", "startVelocity", "getTarget", "getValue", "playTime", "getVelocity", "animation-core_release"})
public final class ExponentialDecay
implements FloatDecayAnimationSpec {
    private final float absVelocityThreshold;
    private final float friction;

    @Override
    public float getAbsVelocityThreshold() {
        return this.absVelocityThreshold;
    }

    @Override
    public float getValue(long playTime, float start, float startVelocity) {
        float f = this.friction * (float)playTime / 1000.0f;
        boolean bl = false;
        return start - startVelocity / this.friction + startVelocity / this.friction * (float)Math.exp(f);
    }

    @Override
    public float getVelocity(long playTime, float start, float startVelocity) {
        float f = (float)playTime / 1000.0f * this.friction;
        boolean bl = false;
        return startVelocity * (float)Math.exp(f);
    }

    @Override
    public long getDurationMillis(float start, float startVelocity) {
        boolean bl = false;
        float f = this.getAbsVelocityThreshold() / Math.abs(startVelocity);
        boolean bl2 = false;
        return (long)(1000.0f * (float)Math.log(f) / this.friction);
    }

    @Override
    public float getTarget(float start, float startVelocity) {
        boolean bl = false;
        if (Math.abs(startVelocity) <= this.getAbsVelocityThreshold()) {
            return start;
        }
        float f = this.getAbsVelocityThreshold() / startVelocity;
        boolean bl2 = false;
        double d = Math.abs(f);
        boolean bl3 = false;
        double duration2 = Math.log(d) / (double)this.friction * (double)1000;
        d = (double)this.friction * duration2 / (double)1000.0f;
        bl3 = false;
        return start - startVelocity / this.friction + startVelocity / this.friction * (float)Math.exp(d);
    }

    public ExponentialDecay(@FloatRange(from=0.0, to=3.4E38, fromInclusive=false) float frictionMultiplier, @FloatRange(from=0.0, to=3.4E38, fromInclusive=false) float absVelocityThreshold) {
        float f = 1.0E-7f;
        boolean bl = false;
        float f2 = Math.abs(absVelocityThreshold);
        boolean bl2 = false;
        this.absVelocityThreshold = Math.max(f, f2);
        f = 1.0E-4f;
        boolean bl3 = false;
        this.friction = -4.2f * Math.max(f, frictionMultiplier);
    }

    public /* synthetic */ ExponentialDecay(float f, float f2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 1.0f;
        }
        if ((n & 2) != 0) {
            f2 = 0.1f;
        }
        this(f, f2);
    }

    public ExponentialDecay() {
        this(0.0f, 0.0f, 3, null);
    }
}

