/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.Animation;
import androidx.compose.animation.core.AnimationClockObservable;
import androidx.compose.animation.core.AnimationClockObserver;
import androidx.compose.animation.core.AnimationEndReason;
import androidx.compose.animation.core.AnimationSpec;
import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.AnimationVectorsKt;
import androidx.compose.animation.core.SpringSpec;
import androidx.compose.animation.core.TargetBasedAnimation;
import androidx.compose.animation.core.TwoWayConverter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u00032\u00020\u0004B-\b\u0002\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\nJA\u00109\u001a\u00020$2\u0006\u0010+\u001a\u00028\u00002\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000:2\u001c\b\u0002\u0010!\u001a\u0016\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020$\u0018\u00010\"\u00a2\u0006\u0002\u0010;J\u0010\u0010<\u001a\u00020$2\u0006\u0010=\u001a\u00020 H\u0014J\u0010\u0010>\u001a\u00020$2\u0006\u0010?\u001a\u00020 H\u0002J\u0017\u0010@\u001a\u00020$2\b\b\u0002\u0010A\u001a\u00020#H\u0000\u00a2\u0006\u0002\bBJ\u001f\u0010C\u001a\u00020$2\u0006\u0010A\u001a\u00020#2\u0006\u0010D\u001a\u00028\u0000H\u0000\u00a2\u0006\u0004\bE\u0010FJ\u0015\u0010G\u001a\u00020$2\u0006\u0010+\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010.J!\u0010H\u001a\u00020$2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0014H\u0000\u00a2\u0006\u0002\bIJ\u0006\u0010J\u001a\u00020$R\u001a\u0010\u000b\u001a\u0004\u0018\u00018\u00008BX\u0082\u000e\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000f\u001a\u0004\u0018\u00018\u00018BX\u0082\u000e\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R.\u0010!\u001a\u0016\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020$\u0018\u00010\"X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010+\u001a\u00028\u00002\u0006\u0010*\u001a\u00028\u00008F@@X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010\r\"\u0004\b-\u0010.R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\"\u00101\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00028\u0000@dX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b2\u0010\r\"\u0004\b3\u0010.R$\u00104\u001a\u00028\u00012\u0006\u00101\u001a\u00028\u00018@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b5\u0010\u0011\"\u0004\b6\u00107R\u0018\u0010\t\u001a\u0004\u0018\u00018\u0000X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b8\u0010\r\u0082\u0001\u0002KL\u00a8\u0006M"}, d2={"Landroidx/compose/animation/core/BaseAnimatedValue;", "T", "V", "Landroidx/compose/animation/core/AnimationVector;", "", "typeConverter", "Landroidx/compose/animation/core/TwoWayConverter;", "clock", "Landroidx/compose/animation/core/AnimationClockObservable;", "visibilityThreshold", "(Landroidx/compose/animation/core/TwoWayConverter;Landroidx/compose/animation/core/AnimationClockObservable;Ljava/lang/Object;)V", "_targetBackingField", "get_targetBackingField", "()Ljava/lang/Object;", "Ljava/lang/Object;", "_velocityBackField", "get_velocityBackField", "()Landroidx/compose/animation/core/AnimationVector;", "Landroidx/compose/animation/core/AnimationVector;", "anim", "Landroidx/compose/animation/core/Animation;", "animationClockObserver", "Landroidx/compose/animation/core/AnimationClockObserver;", "defaultSpringSpec", "Landroidx/compose/animation/core/SpringSpec;", "<set-?>", "", "isRunning", "()Z", "setRunning$animation_core_release", "(Z)V", "lastFrameTime", "", "onEnd", "Lkotlin/Function2;", "Landroidx/compose/animation/core/AnimationEndReason;", "", "getOnEnd$animation_core_release", "()Lkotlin/jvm/functions/Function2;", "setOnEnd$animation_core_release", "(Lkotlin/jvm/functions/Function2;)V", "startTime", "newTarget", "targetValue", "getTargetValue", "setTargetValue$animation_core_release", "(Ljava/lang/Object;)V", "getTypeConverter$animation_core_release", "()Landroidx/compose/animation/core/TwoWayConverter;", "value", "getValue", "setValue", "velocityVector", "getVelocityVector$animation_core_release", "setVelocityVector$animation_core_release", "(Landroidx/compose/animation/core/AnimationVector;)V", "getVisibilityThreshold$animation_core_release", "animateTo", "Landroidx/compose/animation/core/AnimationSpec;", "(Ljava/lang/Object;Landroidx/compose/animation/core/AnimationSpec;Lkotlin/jvm/functions/Function2;)V", "checkFinished", "playtime", "doAnimationFrame", "timeMillis", "endAnimation", "endReason", "endAnimation$animation_core_release", "notifyEnded", "endValue", "notifyEnded$animation_core_release", "(Landroidx/compose/animation/core/AnimationEndReason;Ljava/lang/Object;)V", "snapTo", "startAnimation", "startAnimation$animation_core_release", "stop", "Landroidx/compose/animation/core/AnimatedValue;", "Landroidx/compose/animation/core/AnimatedFloat;", "animation-core_release"})
public abstract class BaseAnimatedValue<T, V extends AnimationVector> {
    private boolean isRunning;
    private T _targetBackingField;
    private V _velocityBackField;
    @Nullable
    private Function2<? super AnimationEndReason, ? super T, Unit> onEnd;
    private Animation<T, V> anim;
    private long startTime;
    private long lastFrameTime;
    private AnimationClockObserver animationClockObserver;
    private final SpringSpec<T> defaultSpringSpec;
    @NotNull
    private final TwoWayConverter<T, V> typeConverter;
    private final AnimationClockObservable clock;
    @Nullable
    private final T visibilityThreshold;

    public abstract T getValue();

    protected abstract void setValue(T var1);

    public final boolean isRunning() {
        return this.isRunning;
    }

    public final void setRunning$animation_core_release(boolean bl) {
        this.isRunning = bl;
    }

    public final T getTargetValue() {
        if (this.get_targetBackingField() != null) {
            T t = this.get_targetBackingField();
            Intrinsics.checkNotNull(t);
            return t;
        }
        return this.getValue();
    }

    public final void setTargetValue$animation_core_release(T newTarget) {
        this._targetBackingField = newTarget;
    }

    private final T get_targetBackingField() {
        if (this._targetBackingField == null) {
            this._targetBackingField = this.getValue();
        }
        return this._targetBackingField;
    }

    @NotNull
    public final V getVelocityVector$animation_core_release() {
        V v = this.get_velocityBackField();
        Intrinsics.checkNotNull(v);
        return v;
    }

    public final void setVelocityVector$animation_core_release(@NotNull V value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this._velocityBackField = value;
    }

    private final V get_velocityBackField() {
        if (this._velocityBackField == null) {
            this._velocityBackField = AnimationVectorsKt.newInstance((AnimationVector)this.typeConverter.getConvertToVector().invoke(this.getValue()));
        }
        return this._velocityBackField;
    }

    @Nullable
    public final Function2<AnimationEndReason, T, Unit> getOnEnd$animation_core_release() {
        return this.onEnd;
    }

    public final void setOnEnd$animation_core_release(@Nullable Function2<? super AnimationEndReason, ? super T, Unit> function2) {
        this.onEnd = function2;
    }

    public final void animateTo(T targetValue, @NotNull AnimationSpec<T> anim, @Nullable Function2<? super AnimationEndReason, ? super T, Unit> onEnd) {
        Intrinsics.checkNotNullParameter(anim, (String)"anim");
        if (this.isRunning) {
            this.notifyEnded$animation_core_release(AnimationEndReason.Interrupted, this.getValue());
        }
        this.setTargetValue$animation_core_release(targetValue);
        TargetBasedAnimation<T, V> animationWrapper = new TargetBasedAnimation<T, V>(anim.vectorize(this.typeConverter), this.getValue(), targetValue, this.getVelocityVector$animation_core_release(), this.typeConverter);
        this.onEnd = onEnd;
        this.startAnimation$animation_core_release(animationWrapper);
    }

    public static /* synthetic */ void animateTo$default(BaseAnimatedValue baseAnimatedValue, Object object, AnimationSpec animationSpec, Function2 function2, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: animateTo");
        }
        if ((n & 2) != 0) {
            animationSpec = baseAnimatedValue.defaultSpringSpec;
        }
        if ((n & 4) != 0) {
            function2 = null;
        }
        baseAnimatedValue.animateTo(object, animationSpec, function2);
    }

    public void snapTo(T targetValue) {
        this.stop();
        this.setValue(targetValue);
        this.setTargetValue$animation_core_release(targetValue);
    }

    public final void stop() {
        if (this.isRunning) {
            this.endAnimation$animation_core_release(AnimationEndReason.Interrupted);
        }
    }

    public final void notifyEnded$animation_core_release(@NotNull AnimationEndReason endReason, T endValue) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)endReason), (String)"endReason");
            Function2<? super AnimationEndReason, ? super T, Unit> onEnd = this.onEnd;
            this.onEnd = null;
            Function2<? super AnimationEndReason, ? super T, Unit> function2 = onEnd;
            if (function2 == null) break block0;
            Unit cfr_ignored_0 = (Unit)function2.invoke((Object)endReason, endValue);
        }
    }

    private final void doAnimationFrame(long timeMillis) {
        long playtime = 0L;
        if (this.startTime == -1L) {
            this.startTime = timeMillis;
            playtime = 0L;
        } else {
            playtime = timeMillis - this.startTime;
        }
        this.lastFrameTime = timeMillis;
        Animation<T, V> animation = this.anim;
        if (animation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"anim");
        }
        this.setValue(animation.getValue(playtime));
        Animation<T, V> animation2 = this.anim;
        if (animation2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"anim");
        }
        this.setVelocityVector$animation_core_release(animation2.getVelocityVector(playtime));
        this.checkFinished(playtime);
    }

    protected void checkFinished(long playtime) {
        boolean animationFinished;
        Animation<T, V> animation = this.anim;
        if (animation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"anim");
        }
        if (animationFinished = animation.isFinished(playtime)) {
            BaseAnimatedValue.endAnimation$animation_core_release$default(this, null, 1, null);
        }
    }

    public final void startAnimation$animation_core_release(@NotNull Animation<T, V> anim) {
        Intrinsics.checkNotNullParameter(anim, (String)"anim");
        this.anim = anim;
        if (anim.isFinished(0L)) {
            BaseAnimatedValue.endAnimation$animation_core_release$default(this, null, 1, null);
            return;
        }
        if (this.isRunning) {
            this.startTime = this.lastFrameTime;
        } else {
            this.startTime = -1L;
            this.isRunning = true;
            this.clock.subscribe(this.animationClockObserver);
        }
    }

    public final void endAnimation$animation_core_release(@NotNull AnimationEndReason endReason) {
        Intrinsics.checkNotNullParameter((Object)((Object)endReason), (String)"endReason");
        this.clock.unsubscribe(this.animationClockObserver);
        this.isRunning = false;
        this.startTime = -1L;
        this.lastFrameTime = -1L;
        this.notifyEnded$animation_core_release(endReason, this.getValue());
        ((AnimationVector)this.getVelocityVector$animation_core_release()).reset$animation_core_release();
    }

    public static /* synthetic */ void endAnimation$animation_core_release$default(BaseAnimatedValue baseAnimatedValue, AnimationEndReason animationEndReason, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: endAnimation");
        }
        if ((n & 1) != 0) {
            animationEndReason = AnimationEndReason.TargetReached;
        }
        baseAnimatedValue.endAnimation$animation_core_release(animationEndReason);
    }

    @NotNull
    public final TwoWayConverter<T, V> getTypeConverter$animation_core_release() {
        return this.typeConverter;
    }

    @Nullable
    public final T getVisibilityThreshold$animation_core_release() {
        return this.visibilityThreshold;
    }

    private BaseAnimatedValue(TwoWayConverter<T, V> typeConverter, AnimationClockObservable clock, T visibilityThreshold) {
        this.typeConverter = typeConverter;
        this.clock = clock;
        this.visibilityThreshold = visibilityThreshold;
        this.startTime = -1L;
        this.lastFrameTime = -1L;
        this.animationClockObserver = new AnimationClockObserver(this){
            final /* synthetic */ BaseAnimatedValue this$0;

            public void onAnimationFrame(long frameTimeMillis) {
                BaseAnimatedValue.access$doAnimationFrame(this.this$0, frameTimeMillis);
            }
            {
                this.this$0 = this$0;
            }
        };
        this.defaultSpringSpec = new SpringSpec(0.0f, 0.0f, this.visibilityThreshold, 3, null);
    }

    public /* synthetic */ BaseAnimatedValue(TwoWayConverter typeConverter, AnimationClockObservable clock, Object visibilityThreshold, DefaultConstructorMarker $constructor_marker) {
        this(typeConverter, clock, visibilityThreshold);
    }

    public static final /* synthetic */ void access$doAnimationFrame(BaseAnimatedValue $this, long timeMillis) {
        $this.doAnimationFrame(timeMillis);
    }
}

