/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.imagecapture;

import android.util.Size;
import android.view.Surface;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.ForwardingImageProxy;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.ImageReaderProxyProvider;
import androidx.camera.core.ImageReaderProxys;
import androidx.camera.core.Logger;
import androidx.camera.core.MetadataImageReader;
import androidx.camera.core.SafeCloseImageReaderProxy;
import androidx.camera.core.imagecapture.AutoValue_CaptureNode_In;
import androidx.camera.core.imagecapture.AutoValue_CaptureNode_Out;
import androidx.camera.core.imagecapture.NoMetadataImageReader;
import androidx.camera.core.imagecapture.ProcessingRequest;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.ImageReaderProxy;
import androidx.camera.core.impl.ImmediateSurface;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.core.processing.Edge;
import androidx.camera.core.processing.Node;
import androidx.core.util.Consumer;
import androidx.core.util.Preconditions;
import com.google.auto.value.AutoValue;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;

@RequiresApi(api=21)
class CaptureNode
implements Node<In, Out> {
    private static final String TAG = "CaptureNode";
    @VisibleForTesting
    static final int MAX_IMAGES = 4;
    @NonNull
    private final Set<Integer> mPendingStageIds = new HashSet<Integer>();
    ProcessingRequest mCurrentRequest = null;
    @Nullable
    SafeCloseImageReaderProxy mSafeCloseImageReaderProxy;
    @Nullable
    private Out mOutputEdge;
    @Nullable
    private In mInputEdge;

    CaptureNode() {
    }

    @Override
    @NonNull
    public Out transform(@NonNull In inputEdge) {
        Consumer requestConsumer;
        ImageReaderProxy wrappedImageReader;
        boolean hasMetadata;
        Preconditions.checkState((this.mInputEdge == null && this.mSafeCloseImageReaderProxy == null ? 1 : 0) != 0, (String)"CaptureNode does not support recreation yet.");
        this.mInputEdge = inputEdge;
        Size size = inputEdge.getSize();
        int format = inputEdge.getInputFormat();
        boolean bl = hasMetadata = !inputEdge.isVirtualCamera();
        if (hasMetadata && inputEdge.getImageReaderProxyProvider() == null) {
            MetadataImageReader metadataImageReader = new MetadataImageReader(size.getWidth(), size.getHeight(), format, 4);
            inputEdge.setCameraCaptureCallback(metadataImageReader.getCameraCaptureCallback());
            wrappedImageReader = metadataImageReader;
            requestConsumer = this::onRequestAvailable;
        } else {
            NoMetadataImageReader noMetadataImageReader = new NoMetadataImageReader(CaptureNode.createImageReaderProxy(inputEdge.getImageReaderProxyProvider(), size.getWidth(), size.getHeight(), format));
            wrappedImageReader = noMetadataImageReader;
            requestConsumer = request -> {
                this.onRequestAvailable((ProcessingRequest)request);
                noMetadataImageReader.acceptProcessingRequest((ProcessingRequest)request);
            };
        }
        inputEdge.setSurface(Objects.requireNonNull(wrappedImageReader.getSurface()));
        this.mSafeCloseImageReaderProxy = new SafeCloseImageReaderProxy(wrappedImageReader);
        wrappedImageReader.setOnImageAvailableListener(imageReader -> {
            try {
                ImageProxy image = imageReader.acquireLatestImage();
                if (image != null) {
                    this.onImageProxyAvailable(image);
                } else {
                    this.sendCaptureError(new ImageCaptureException(2, "Failed to acquire latest image", null));
                }
            }
            catch (IllegalStateException e) {
                this.sendCaptureError(new ImageCaptureException(2, "Failed to acquire latest image", e));
            }
        }, CameraXExecutors.mainThreadExecutor());
        inputEdge.getRequestEdge().setListener((Consumer<ProcessingRequest>)requestConsumer);
        inputEdge.getErrorEdge().setListener((Consumer<ImageCaptureException>)((Consumer)this::sendCaptureError));
        this.mOutputEdge = Out.of(inputEdge.getInputFormat(), inputEdge.getOutputFormat());
        return this.mOutputEdge;
    }

    @NonNull
    private static ImageReaderProxy createImageReaderProxy(@Nullable ImageReaderProxyProvider imageReaderProxyProvider, int width, int height, int format) {
        if (imageReaderProxyProvider != null) {
            return imageReaderProxyProvider.newInstance(width, height, format, 4, 0L);
        }
        return ImageReaderProxys.createIsolatedReader(width, height, format, 4);
    }

    @VisibleForTesting
    @MainThread
    void onImageProxyAvailable(@NonNull ImageProxy imageProxy) {
        Threads.checkMainThread();
        if (this.mCurrentRequest == null) {
            Logger.d(TAG, "Discarding ImageProxy which was inadvertently acquired: " + imageProxy);
            imageProxy.close();
        } else {
            this.matchAndPropagateImage(imageProxy);
        }
    }

    private void matchAndPropagateImage(@NonNull ImageProxy imageProxy) {
        int stageId = (Integer)Objects.requireNonNull(imageProxy.getImageInfo().getTagBundle().getTag(this.mCurrentRequest.getTagBundleKey()));
        Preconditions.checkState((boolean)this.mPendingStageIds.contains(stageId), (String)("Received an unexpected stage id" + stageId));
        this.mPendingStageIds.remove(stageId);
        Objects.requireNonNull(this.mOutputEdge).getImageEdge().accept(imageProxy);
        if (this.mPendingStageIds.isEmpty()) {
            ProcessingRequest request = this.mCurrentRequest;
            this.mCurrentRequest = null;
            request.onImageCaptured();
        }
    }

    @VisibleForTesting
    @MainThread
    void onRequestAvailable(final @NonNull ProcessingRequest request) {
        Threads.checkMainThread();
        Preconditions.checkState((this.getCapacity() > 0 ? 1 : 0) != 0, (String)"Too many acquire images. Close image to be able to process next.");
        Preconditions.checkState((this.mCurrentRequest == null || this.mPendingStageIds.isEmpty() ? 1 : 0) != 0, (String)"The previous request is not complete");
        this.mCurrentRequest = request;
        this.mPendingStageIds.addAll(request.getStageIds());
        Objects.requireNonNull(this.mOutputEdge).getRequestEdge().accept(request);
        Futures.addCallback(request.getCaptureFuture(), new FutureCallback<Void>(){

            @Override
            public void onSuccess(@Nullable Void result) {
            }

            @Override
            public void onFailure(@NonNull Throwable t) {
                Threads.checkMainThread();
                if (request == CaptureNode.this.mCurrentRequest) {
                    CaptureNode.this.mCurrentRequest = null;
                }
            }
        }, CameraXExecutors.directExecutor());
    }

    @MainThread
    void sendCaptureError(@NonNull ImageCaptureException e) {
        Threads.checkMainThread();
        if (this.mCurrentRequest != null) {
            this.mCurrentRequest.onCaptureFailure(e);
        }
    }

    @Override
    @MainThread
    public void release() {
        Threads.checkMainThread();
        this.releaseInputResources(Objects.requireNonNull(this.mInputEdge), Objects.requireNonNull(this.mSafeCloseImageReaderProxy));
    }

    private void releaseInputResources(@NonNull In inputEdge, @NonNull SafeCloseImageReaderProxy imageReader) {
        inputEdge.getSurface().close();
        inputEdge.getSurface().getTerminationFuture().addListener(imageReader::safeClose, (Executor)CameraXExecutors.mainThreadExecutor());
    }

    @VisibleForTesting
    @NonNull
    In getInputEdge() {
        return Objects.requireNonNull(this.mInputEdge);
    }

    @VisibleForTesting
    @NonNull
    public SafeCloseImageReaderProxy getSafeCloseImageReaderProxy() {
        return Objects.requireNonNull(this.mSafeCloseImageReaderProxy);
    }

    @MainThread
    public int getCapacity() {
        Threads.checkMainThread();
        Preconditions.checkState((this.mSafeCloseImageReaderProxy != null ? 1 : 0) != 0, (String)"The ImageReader is not initialized.");
        return this.mSafeCloseImageReaderProxy.getCapacity();
    }

    @MainThread
    public void setOnImageCloseListener(ForwardingImageProxy.OnImageCloseListener listener) {
        Threads.checkMainThread();
        Preconditions.checkState((this.mSafeCloseImageReaderProxy != null ? 1 : 0) != 0, (String)"The ImageReader is not initialized.");
        this.mSafeCloseImageReaderProxy.setOnImageCloseListener(listener);
    }

    @AutoValue
    static abstract class In {
        @NonNull
        private CameraCaptureCallback mCameraCaptureCallback = new CameraCaptureCallback(){};
        @Nullable
        private DeferrableSurface mSurface;

        In() {
        }

        abstract Size getSize();

        abstract int getInputFormat();

        abstract int getOutputFormat();

        abstract boolean isVirtualCamera();

        @Nullable
        abstract ImageReaderProxyProvider getImageReaderProxyProvider();

        @NonNull
        abstract Edge<ProcessingRequest> getRequestEdge();

        @NonNull
        abstract Edge<ImageCaptureException> getErrorEdge();

        @NonNull
        DeferrableSurface getSurface() {
            return Objects.requireNonNull(this.mSurface);
        }

        void setSurface(@NonNull Surface surface) {
            Preconditions.checkState((this.mSurface == null ? 1 : 0) != 0, (String)"The surface is already set.");
            this.mSurface = new ImmediateSurface(surface, this.getSize(), this.getInputFormat());
        }

        @NonNull
        CameraCaptureCallback getCameraCaptureCallback() {
            return this.mCameraCaptureCallback;
        }

        void setCameraCaptureCallback(@NonNull CameraCaptureCallback cameraCaptureCallback) {
            this.mCameraCaptureCallback = cameraCaptureCallback;
        }

        @NonNull
        static In of(Size size, int inputFormat, int outputFormat, boolean isVirtualCamera, @Nullable ImageReaderProxyProvider imageReaderProxyProvider) {
            return new AutoValue_CaptureNode_In(size, inputFormat, outputFormat, isVirtualCamera, imageReaderProxyProvider, new Edge<ProcessingRequest>(), new Edge<ImageCaptureException>());
        }
    }

    @AutoValue
    static abstract class Out {
        Out() {
        }

        abstract Edge<ImageProxy> getImageEdge();

        abstract Edge<ProcessingRequest> getRequestEdge();

        abstract int getInputFormat();

        abstract int getOutputFormat();

        static Out of(int inputFormat, int outputFormat) {
            return new AutoValue_CaptureNode_Out(new Edge<ImageProxy>(), new Edge<ProcessingRequest>(), inputFormat, outputFormat);
        }
    }
}

