/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.util;

import org.apache.commons.math3.util.CombinatoricsUtils;

public class MathUtils {
    public static final long LOG_PRECISION = 1000000L;

    private MathUtils() {
    }

    public static long getPossibleArrangementsScaledApproximateLog(long scale, long base, int listSize, int partitions) {
        double result = listSize == 0 || partitions == 0 ? 0.0 : (partitions <= 2 ? CombinatoricsUtils.factorialLog((int)(listSize + partitions - 1)) : CombinatoricsUtils.factorialLog((int)(listSize + partitions - 1)) - CombinatoricsUtils.factorialLog((int)(partitions - 1)));
        return Math.round((double)scale * result / Math.log(base));
    }

    public static long getScaledApproximateLog(long scale, long base, long value) {
        return Math.round((double)scale * MathUtils.getLogInBase(base, value));
    }

    public static double getLogInBase(double base, double value) {
        return Math.log(value) / Math.log(base);
    }

    public static long getSpeed(long count, long timeMillisSpent) {
        return count * 1000L / (timeMillisSpent == 0L ? 1L : timeMillisSpent);
    }
}

