/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver.termination;

import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.solver.termination.AbstractCompositeTermination;
import ai.timefold.solver.core.impl.solver.termination.ChildThreadSupportingTermination;
import ai.timefold.solver.core.impl.solver.termination.PhaseTermination;
import ai.timefold.solver.core.impl.solver.termination.SolverTermination;
import ai.timefold.solver.core.impl.solver.termination.Termination;
import ai.timefold.solver.core.impl.solver.thread.ChildThreadType;
import java.util.List;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class OrCompositeTermination<Solution_>
extends AbstractCompositeTermination<Solution_>
implements ChildThreadSupportingTermination<Solution_, SolverScope<Solution_>> {
    public OrCompositeTermination(List<Termination<Solution_>> terminationList) {
        super(terminationList);
    }

    @SafeVarargs
    public OrCompositeTermination(Termination<Solution_> ... terminations) {
        super(terminations);
    }

    @Override
    public boolean isSolverTerminated(SolverScope<Solution_> solverScope) {
        for (SolverTermination termination : this.solverTerminationList) {
            if (!termination.isSolverTerminated(solverScope)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPhaseTerminated(AbstractPhaseScope<Solution_> phaseScope) {
        for (PhaseTermination termination : this.phaseTerminationList) {
            if (!termination.isApplicableTo(phaseScope.getClass()) || !termination.isPhaseTerminated(phaseScope)) continue;
            return true;
        }
        return false;
    }

    @Override
    public double calculateSolverTimeGradient(SolverScope<Solution_> solverScope) {
        double timeGradient = 0.0;
        for (SolverTermination termination : this.solverTerminationList) {
            double nextTimeGradient = termination.calculateSolverTimeGradient(solverScope);
            if (!(nextTimeGradient >= 0.0)) continue;
            timeGradient = Math.max(timeGradient, nextTimeGradient);
        }
        return timeGradient;
    }

    @Override
    public double calculatePhaseTimeGradient(AbstractPhaseScope<Solution_> phaseScope) {
        double timeGradient = 0.0;
        for (PhaseTermination termination : this.phaseTerminationList) {
            double nextTimeGradient;
            if (!termination.isApplicableTo(phaseScope.getClass()) || !((nextTimeGradient = termination.calculatePhaseTimeGradient(phaseScope)) >= 0.0)) continue;
            timeGradient = Math.max(timeGradient, nextTimeGradient);
        }
        return timeGradient;
    }

    @Override
    public OrCompositeTermination<Solution_> createChildThreadTermination(SolverScope<Solution_> solverScope, ChildThreadType childThreadType) {
        return new OrCompositeTermination<Solution_>(this.createChildThreadTerminationList(solverScope, childThreadType));
    }

    public String toString() {
        return "Or(" + String.valueOf(this.terminationList) + ")";
    }
}

