/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver;

import ai.timefold.solver.core.api.solver.SolverJobBuilder;
import ai.timefold.solver.core.impl.solver.BestSolutionContainingProblemChanges;
import ai.timefold.solver.core.impl.solver.BestSolutionHolder;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;

final class ConsumerSupport<Solution_, ProblemId_>
implements AutoCloseable {
    private final ProblemId_ problemId;
    private final Consumer<? super Solution_> bestSolutionConsumer;
    private final Consumer<? super Solution_> finalBestSolutionConsumer;
    private final SolverJobBuilder.FirstInitializedSolutionConsumer<? super Solution_> firstInitializedSolutionConsumer;
    private final Consumer<? super Solution_> solverJobStartedConsumer;
    private final BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler;
    private final Semaphore activeConsumption = new Semaphore(1);
    private final Semaphore firstSolutionConsumption = new Semaphore(1);
    private final Semaphore startSolverJobConsumption = new Semaphore(1);
    private final BestSolutionHolder<Solution_> bestSolutionHolder;
    private final ExecutorService consumerExecutor = Executors.newSingleThreadExecutor();
    private Solution_ firstInitializedSolution;
    private Solution_ initialSolution;

    public ConsumerSupport(ProblemId_ problemId, Consumer<? super Solution_> bestSolutionConsumer, Consumer<? super Solution_> finalBestSolutionConsumer, SolverJobBuilder.FirstInitializedSolutionConsumer<? super Solution_> firstInitializedSolutionConsumer, Consumer<? super Solution_> solverJobStartedConsumer, BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler, BestSolutionHolder<Solution_> bestSolutionHolder) {
        this.problemId = problemId;
        this.bestSolutionConsumer = bestSolutionConsumer;
        this.finalBestSolutionConsumer = finalBestSolutionConsumer == null ? finalBestSolution -> {} : finalBestSolutionConsumer;
        this.firstInitializedSolutionConsumer = firstInitializedSolutionConsumer == null ? (solution, isTerminatedEarly) -> {} : firstInitializedSolutionConsumer;
        this.solverJobStartedConsumer = solverJobStartedConsumer;
        this.exceptionHandler = exceptionHandler;
        this.bestSolutionHolder = bestSolutionHolder;
        this.firstInitializedSolution = null;
        this.initialSolution = null;
    }

    void consumeIntermediateBestSolution(Solution_ bestSolution, BooleanSupplier isEveryProblemChangeProcessed) {
        this.bestSolutionHolder.set(bestSolution, isEveryProblemChangeProcessed);
        if (this.bestSolutionConsumer != null) {
            this.tryConsumeWaitingIntermediateBestSolution();
        }
    }

    void consumeFirstInitializedSolution(Solution_ firstInitializedSolution, boolean isTerminatedEarly) {
        try {
            this.firstSolutionConsumption.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted when waiting for the first initialized solution consumption.");
        }
        this.firstInitializedSolution = firstInitializedSolution;
        this.scheduleFirstInitializedSolutionConsumption(solution -> this.firstInitializedSolutionConsumer.accept(solution, isTerminatedEarly));
    }

    void consumeStartSolverJob(Solution_ initialSolution) {
        try {
            this.startSolverJobConsumption.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted when waiting for the start solver job consumption.");
        }
        this.initialSolution = initialSolution;
        this.scheduleStartJobConsumption();
    }

    void consumeFinalBestSolution(Solution_ finalBestSolution) {
        try {
            this.acquireAll();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted when waiting for the final best solution consumption.");
        }
        if (this.bestSolutionConsumer != null) {
            this.scheduleIntermediateBestSolutionConsumption();
        }
        this.consumerExecutor.submit(() -> {
            try {
                this.finalBestSolutionConsumer.accept(finalBestSolution);
            }
            catch (Throwable throwable) {
                this.exceptionHandler.accept(this.problemId, throwable);
            }
            finally {
                BestSolutionContainingProblemChanges<Solution_> solutionHolder;
                if (this.bestSolutionConsumer == null && (solutionHolder = this.bestSolutionHolder.take()) != null) {
                    solutionHolder.completeProblemChanges();
                }
                this.bestSolutionHolder.cancelPendingChanges();
                this.releaseAll();
                this.disposeConsumerThread();
            }
        });
    }

    private void tryConsumeWaitingIntermediateBestSolution() {
        if (this.bestSolutionHolder.isEmpty()) {
            return;
        }
        if (this.activeConsumption.tryAcquire()) {
            this.scheduleIntermediateBestSolutionConsumption().thenRunAsync(this::tryConsumeWaitingIntermediateBestSolution, this.consumerExecutor);
        }
    }

    private CompletableFuture<Void> scheduleIntermediateBestSolutionConsumption() {
        return CompletableFuture.runAsync(() -> {
            BestSolutionContainingProblemChanges<Solution_> bestSolutionContainingProblemChanges = this.bestSolutionHolder.take();
            if (bestSolutionContainingProblemChanges != null) {
                try {
                    this.bestSolutionConsumer.accept(bestSolutionContainingProblemChanges.getBestSolution());
                    bestSolutionContainingProblemChanges.completeProblemChanges();
                }
                catch (Throwable throwable) {
                    if (this.exceptionHandler != null) {
                        this.exceptionHandler.accept(this.problemId, throwable);
                    }
                    bestSolutionContainingProblemChanges.completeProblemChangesExceptionally(throwable);
                }
                finally {
                    this.activeConsumption.release();
                }
            }
        }, this.consumerExecutor);
    }

    private void scheduleFirstInitializedSolutionConsumption(Consumer<? super Solution_> firstInitializedSolutionConsumer) {
        this.scheduleConsumption(this.firstSolutionConsumption, firstInitializedSolutionConsumer, this.firstInitializedSolution);
    }

    private void scheduleStartJobConsumption() {
        this.scheduleConsumption(this.startSolverJobConsumption, this.solverJobStartedConsumer, this.initialSolution);
    }

    private void scheduleConsumption(Semaphore semaphore, Consumer<? super Solution_> consumer, Solution_ solution) {
        CompletableFuture.runAsync(() -> {
            try {
                if (consumer != null && solution != null) {
                    consumer.accept((Solution_)solution);
                }
            }
            catch (Throwable throwable) {
                if (this.exceptionHandler != null) {
                    this.exceptionHandler.accept(this.problemId, throwable);
                }
            }
            finally {
                semaphore.release();
            }
        }, this.consumerExecutor);
    }

    private void acquireAll() throws InterruptedException {
        this.activeConsumption.acquire();
        this.startSolverJobConsumption.acquire();
        this.firstSolutionConsumption.acquire();
    }

    private void releaseAll() {
        this.activeConsumption.release();
        this.startSolverJobConsumption.release();
        this.firstSolutionConsumption.release();
    }

    @Override
    public void close() {
        try {
            this.acquireAll();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted when waiting for closing the consumer.");
        }
        finally {
            this.disposeConsumerThread();
            this.bestSolutionHolder.cancelPendingChanges();
            this.releaseAll();
        }
    }

    private void disposeConsumerThread() {
        this.consumerExecutor.shutdownNow();
    }
}

