/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.trend;

import ai.timefold.solver.core.config.score.trend.InitializingScoreTrendLevel;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public record InitializingScoreTrend(InitializingScoreTrendLevel[] trendLevels) {
    public static InitializingScoreTrend parseTrend(String initializingScoreTrendString, int levelsSize) {
        boolean tokenIsSingle;
        String[] trendTokens = initializingScoreTrendString.split("/");
        boolean bl = tokenIsSingle = trendTokens.length == 1;
        if (!tokenIsSingle && trendTokens.length != levelsSize) {
            throw new IllegalArgumentException("The initializingScoreTrendString (%s) doesn't follow the correct pattern (%s): the trendTokens length (%d) differs from the levelsSize (%d).".formatted(initializingScoreTrendString, InitializingScoreTrend.buildTrendPattern(levelsSize), trendTokens.length, levelsSize));
        }
        InitializingScoreTrendLevel[] trendLevels = new InitializingScoreTrendLevel[levelsSize];
        for (int i = 0; i < levelsSize; ++i) {
            trendLevels[i] = InitializingScoreTrendLevel.valueOf(trendTokens[tokenIsSingle ? 0 : i]);
        }
        return new InitializingScoreTrend(trendLevels);
    }

    public static InitializingScoreTrend buildUniformTrend(InitializingScoreTrendLevel trendLevel, int levelsSize) {
        InitializingScoreTrendLevel[] trendLevels = new InitializingScoreTrendLevel[levelsSize];
        Arrays.fill((Object[])trendLevels, (Object)trendLevel);
        return new InitializingScoreTrend(trendLevels);
    }

    private static String buildTrendPattern(int levelsSize) {
        return Stream.generate(InitializingScoreTrendLevel.ANY::name).limit(levelsSize).collect(Collectors.joining("/"));
    }

    public int getLevelsSize() {
        return this.trendLevels.length;
    }

    public boolean isOnlyUp() {
        for (InitializingScoreTrendLevel trendLevel : this.trendLevels) {
            if (trendLevel == InitializingScoreTrendLevel.ONLY_UP) continue;
            return false;
        }
        return true;
    }

    public boolean isOnlyDown() {
        for (InitializingScoreTrendLevel trendLevel : this.trendLevels) {
            if (trendLevel == InitializingScoreTrendLevel.ONLY_DOWN) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (!(o instanceof InitializingScoreTrend)) return false;
        InitializingScoreTrend that = (InitializingScoreTrend)o;
        if (!Arrays.equals((Object[])this.trendLevels, (Object[])that.trendLevels)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode((Object[])this.trendLevels);
    }

    @Override
    public String toString() {
        return "InitializingScoreTrend(%s)".formatted(Arrays.toString((Object[])this.trendLevels));
    }
}

