/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.common.uni;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.api.score.stream.DefaultConstraintJustification;
import ai.timefold.solver.core.api.score.stream.bi.BiConstraintStream;
import ai.timefold.solver.core.api.score.stream.bi.BiJoiner;
import ai.timefold.solver.core.api.score.stream.uni.UniConstraintBuilder;
import ai.timefold.solver.core.api.score.stream.uni.UniConstraintStream;
import ai.timefold.solver.core.impl.bavet.bi.joiner.BiJoinerComber;
import ai.timefold.solver.core.impl.score.stream.common.RetrievalSemantics;
import ai.timefold.solver.core.impl.score.stream.common.ScoreImpactType;
import ai.timefold.solver.core.impl.util.ConstantLambdaUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.jspecify.annotations.NonNull;

public interface InnerUniConstraintStream<A>
extends UniConstraintStream<A> {
    public static <A> BiFunction<A, Score<?>, DefaultConstraintJustification> createDefaultJustificationMapping() {
        return (a, score) -> DefaultConstraintJustification.of(score, a);
    }

    public static <A> Function<A, Collection<?>> createDefaultIndictedObjectsMapping() {
        return Collections::singletonList;
    }

    public RetrievalSemantics getRetrievalSemantics();

    public boolean guaranteesDistinct();

    @Override
    default public <B> @NonNull BiConstraintStream<A, B> join(@NonNull Class<B> otherClass, BiJoiner<A, B> ... joiners) {
        if (this.getRetrievalSemantics() == RetrievalSemantics.STANDARD) {
            return this.join(this.getConstraintFactory().forEach(otherClass), joiners);
        }
        return this.join(this.getConstraintFactory().from(otherClass), joiners);
    }

    @Override
    public <B> BiConstraintStream<A, B> join(UniConstraintStream<B> var1, BiJoinerComber<A, B> var2);

    @Override
    default public <B> @NonNull UniConstraintStream<A> ifExists(@NonNull Class<B> otherClass, BiJoiner<A, B> ... joiners) {
        if (this.getRetrievalSemantics() == RetrievalSemantics.STANDARD) {
            return this.ifExists(this.getConstraintFactory().forEach(otherClass), joiners);
        }
        return this.ifExists(this.getConstraintFactory().fromUnfiltered(otherClass), joiners);
    }

    @Override
    default public <B> @NonNull UniConstraintStream<A> ifExistsIncludingUnassigned(@NonNull Class<B> otherClass, BiJoiner<A, B> ... joiners) {
        if (this.getRetrievalSemantics() == RetrievalSemantics.STANDARD) {
            return this.ifExists(this.getConstraintFactory().forEachIncludingUnassigned(otherClass), joiners);
        }
        return this.ifExists(this.getConstraintFactory().fromUnfiltered(otherClass), joiners);
    }

    @Override
    default public <B> @NonNull UniConstraintStream<A> ifNotExists(@NonNull Class<B> otherClass, BiJoiner<A, B> ... joiners) {
        if (this.getRetrievalSemantics() == RetrievalSemantics.STANDARD) {
            return this.ifNotExists(this.getConstraintFactory().forEach(otherClass), joiners);
        }
        return this.ifNotExists(this.getConstraintFactory().fromUnfiltered(otherClass), joiners);
    }

    @Override
    default public <B> @NonNull UniConstraintStream<A> ifNotExistsIncludingUnassigned(@NonNull Class<B> otherClass, BiJoiner<A, B> ... joiners) {
        if (this.getRetrievalSemantics() == RetrievalSemantics.STANDARD) {
            return this.ifNotExists(this.getConstraintFactory().forEachIncludingUnassigned(otherClass), joiners);
        }
        return this.ifNotExists(this.getConstraintFactory().fromUnfiltered(otherClass), joiners);
    }

    @Override
    default public @NonNull UniConstraintStream<A> distinct() {
        if (this.guaranteesDistinct()) {
            return this;
        }
        return this.groupBy(ConstantLambdaUtils.identity());
    }

    @Override
    default public <Score_ extends Score<Score_>> @NonNull UniConstraintBuilder<A, Score_> penalize(@NonNull Score_ constraintWeight, @NonNull ToIntFunction<A> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.PENALTY);
    }

    @Override
    default public <Score_ extends Score<Score_>> @NonNull UniConstraintBuilder<A, Score_> penalizeLong(@NonNull Score_ constraintWeight, @NonNull ToLongFunction<A> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.PENALTY);
    }

    @Override
    default public <Score_ extends Score<Score_>> @NonNull UniConstraintBuilder<A, Score_> penalizeBigDecimal(@NonNull Score_ constraintWeight, @NonNull Function<A, BigDecimal> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.PENALTY);
    }

    @Override
    default public UniConstraintBuilder<A, ?> penalizeConfigurable(ToIntFunction<A> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.PENALTY);
    }

    @Override
    default public UniConstraintBuilder<A, ?> penalizeConfigurableLong(ToLongFunction<A> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.PENALTY);
    }

    @Override
    default public UniConstraintBuilder<A, ?> penalizeConfigurableBigDecimal(Function<A, BigDecimal> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.PENALTY);
    }

    @Override
    default public <Score_ extends Score<Score_>> @NonNull UniConstraintBuilder<A, Score_> reward(@NonNull Score_ constraintWeight, @NonNull ToIntFunction<A> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.REWARD);
    }

    @Override
    default public <Score_ extends Score<Score_>> @NonNull UniConstraintBuilder<A, Score_> rewardLong(@NonNull Score_ constraintWeight, @NonNull ToLongFunction<A> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.REWARD);
    }

    @Override
    default public <Score_ extends Score<Score_>> @NonNull UniConstraintBuilder<A, Score_> rewardBigDecimal(@NonNull Score_ constraintWeight, @NonNull Function<A, BigDecimal> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.REWARD);
    }

    @Override
    default public UniConstraintBuilder<A, ?> rewardConfigurable(ToIntFunction<A> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.REWARD);
    }

    @Override
    default public UniConstraintBuilder<A, ?> rewardConfigurableLong(ToLongFunction<A> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.REWARD);
    }

    @Override
    default public UniConstraintBuilder<A, ?> rewardConfigurableBigDecimal(Function<A, BigDecimal> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.REWARD);
    }

    @Override
    default public <Score_ extends Score<Score_>> @NonNull UniConstraintBuilder<A, Score_> impact(@NonNull Score_ constraintWeight, @NonNull ToIntFunction<A> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.MIXED);
    }

    @Override
    default public <Score_ extends Score<Score_>> @NonNull UniConstraintBuilder<A, Score_> impactLong(@NonNull Score_ constraintWeight, @NonNull ToLongFunction<A> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.MIXED);
    }

    @Override
    default public <Score_ extends Score<Score_>> @NonNull UniConstraintBuilder<A, Score_> impactBigDecimal(@NonNull Score_ constraintWeight, @NonNull Function<A, BigDecimal> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.MIXED);
    }

    @Override
    default public UniConstraintBuilder<A, ?> impactConfigurable(ToIntFunction<A> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.MIXED);
    }

    @Override
    default public UniConstraintBuilder<A, ?> impactConfigurableLong(ToLongFunction<A> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.MIXED);
    }

    @Override
    default public UniConstraintBuilder<A, ?> impactConfigurableBigDecimal(Function<A, BigDecimal> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.MIXED);
    }

    public <Score_ extends Score<Score_>> UniConstraintBuilder<A, Score_> innerImpact(Score_ var1, ToIntFunction<A> var2, ScoreImpactType var3);

    public <Score_ extends Score<Score_>> UniConstraintBuilder<A, Score_> innerImpact(Score_ var1, ToLongFunction<A> var2, ScoreImpactType var3);

    public <Score_ extends Score<Score_>> UniConstraintBuilder<A, Score_> innerImpact(Score_ var1, Function<A, BigDecimal> var2, ScoreImpactType var3);

    @Override
    default public @NonNull Constraint penalize(@NonNull String constraintName, @NonNull Score<?> constraintWeight) {
        return this.penalize(constraintWeight).asConstraint(constraintName);
    }

    @Override
    default public @NonNull Constraint penalize(@NonNull String constraintPackage, @NonNull String constraintName, @NonNull Score<?> constraintWeight) {
        return this.penalize(constraintWeight).asConstraint(constraintPackage, constraintName);
    }

    @Override
    default public @NonNull Constraint penalizeConfigurable(@NonNull String constraintName) {
        return this.penalizeConfigurable().asConstraint(constraintName);
    }

    @Override
    default public @NonNull Constraint penalizeConfigurable(@NonNull String constraintPackage, @NonNull String constraintName) {
        return this.penalizeConfigurable().asConstraint(constraintPackage, constraintName);
    }

    @Override
    default public @NonNull Constraint reward(@NonNull String constraintName, @NonNull Score<?> constraintWeight) {
        return this.reward(constraintWeight).asConstraint(constraintName);
    }

    @Override
    default public @NonNull Constraint reward(@NonNull String constraintPackage, @NonNull String constraintName, @NonNull Score<?> constraintWeight) {
        return this.reward(constraintWeight).asConstraint(constraintPackage, constraintName);
    }

    @Override
    default public @NonNull Constraint rewardConfigurable(@NonNull String constraintName) {
        return this.rewardConfigurable().asConstraint(constraintName);
    }

    @Override
    default public @NonNull Constraint rewardConfigurable(@NonNull String constraintPackage, @NonNull String constraintName) {
        return this.penalizeConfigurable().asConstraint(constraintPackage, constraintName);
    }

    @Override
    default public @NonNull Constraint impact(@NonNull String constraintName, @NonNull Score<?> constraintWeight) {
        return this.impact(constraintWeight).asConstraint(constraintName);
    }

    @Override
    default public @NonNull Constraint impact(@NonNull String constraintPackage, @NonNull String constraintName, @NonNull Score<?> constraintWeight) {
        return this.impact(constraintWeight).asConstraint(constraintPackage, constraintName);
    }
}

