/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector.uni;

import ai.timefold.solver.core.api.score.stream.uni.UniConstraintCollector;
import ai.timefold.solver.core.impl.score.stream.collector.ObjectCalculator;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class ObjectCalculatorUniCollector<A, Input_, Output_, Mapped_, Calculator_ extends ObjectCalculator<Input_, Output_, Mapped_>>
implements UniConstraintCollector<A, Calculator_, Output_> {
    protected final Function<? super A, ? extends Input_> mapper;

    public ObjectCalculatorUniCollector(Function<? super A, ? extends Input_> mapper) {
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public @NonNull BiFunction<Calculator_, A, Runnable> accumulator() {
        return (calculator, a) -> {
            Input_ mapped = this.mapper.apply(a);
            Object saved = calculator.insert(mapped);
            return () -> calculator.retract(saved);
        };
    }

    @Override
    public @Nullable Function<Calculator_, Output_> finisher() {
        return ObjectCalculator::result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ObjectCalculatorUniCollector that = (ObjectCalculatorUniCollector)object;
        return Objects.equals(this.mapper, that.mapper);
    }

    public int hashCode() {
        return Objects.hash(this.mapper);
    }
}

