/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector.tri;

import ai.timefold.solver.core.api.function.QuadFunction;
import ai.timefold.solver.core.api.function.ToIntTriFunction;
import ai.timefold.solver.core.api.function.ToLongTriFunction;
import ai.timefold.solver.core.api.function.TriFunction;
import ai.timefold.solver.core.api.function.TriPredicate;
import ai.timefold.solver.core.api.score.stream.common.ConnectedRangeChain;
import ai.timefold.solver.core.api.score.stream.common.LoadBalance;
import ai.timefold.solver.core.api.score.stream.common.SequenceChain;
import ai.timefold.solver.core.api.score.stream.tri.TriConstraintCollector;
import ai.timefold.solver.core.impl.score.stream.collector.ReferenceAverageCalculator;
import ai.timefold.solver.core.impl.score.stream.collector.tri.AndThenTriCollector;
import ai.timefold.solver.core.impl.score.stream.collector.tri.AverageIntTriCollector;
import ai.timefold.solver.core.impl.score.stream.collector.tri.AverageLongTriCollector;
import ai.timefold.solver.core.impl.score.stream.collector.tri.AverageReferenceTriCollector;
import ai.timefold.solver.core.impl.score.stream.collector.tri.ComposeFourTriCollector;
import ai.timefold.solver.core.impl.score.stream.collector.tri.ComposeThreeTriCollector;
import ai.timefold.solver.core.impl.score.stream.collector.tri.ComposeTwoTriCollector;
import ai.timefold.solver.core.impl.score.stream.collector.tri.ConditionalTriCollector;
import ai.timefold.solver.core.impl.score.stream.collector.tri.ConnectedRangesTriConstraintCollector;
import ai.timefold.solver.core.impl.score.stream.collector.tri.ConsecutiveSequencesTriConstraintCollector;
import ai.timefold.solver.core.impl.score.stream.collector.tri.CountDistinctIntTriCollector;
import ai.timefold.solver.core.impl.score.stream.collector.tri.CountDistinctLongTriCollector;
import ai.timefold.solver.core.impl.score.stream.collector.tri.CountIntTriCollector;
import ai.timefold.solver.core.impl.score.stream.collector.tri.CountLongTriCollector;
import ai.timefold.solver.core.impl.score.stream.collector.tri.LoadBalanceTriCollector;
import ai.timefold.solver.core.impl.score.stream.collector.tri.MaxComparableTriCollector;
import ai.timefold.solver.core.impl.score.stream.collector.tri.MaxComparatorTriCollector;
import ai.timefold.solver.core.impl.score.stream.collector.tri.MaxPropertyTriCollector;
import ai.timefold.solver.core.impl.score.stream.collector.tri.MinComparableTriCollector;
import ai.timefold.solver.core.impl.score.stream.collector.tri.MinComparatorTriCollector;
import ai.timefold.solver.core.impl.score.stream.collector.tri.MinPropertyTriCollector;
import ai.timefold.solver.core.impl.score.stream.collector.tri.SumIntTriCollector;
import ai.timefold.solver.core.impl.score.stream.collector.tri.SumLongTriCollector;
import ai.timefold.solver.core.impl.score.stream.collector.tri.SumReferenceTriCollector;
import ai.timefold.solver.core.impl.score.stream.collector.tri.ToCollectionTriCollector;
import ai.timefold.solver.core.impl.score.stream.collector.tri.ToListTriCollector;
import ai.timefold.solver.core.impl.score.stream.collector.tri.ToMultiMapTriCollector;
import ai.timefold.solver.core.impl.score.stream.collector.tri.ToSetTriCollector;
import ai.timefold.solver.core.impl.score.stream.collector.tri.ToSimpleMapTriCollector;
import ai.timefold.solver.core.impl.score.stream.collector.tri.ToSortedSetComparatorTriCollector;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;

public class InnerTriConstraintCollectors {
    public static <A, B, C> TriConstraintCollector<A, B, C, ?, Double> average(ToIntTriFunction<? super A, ? super B, ? super C> mapper) {
        return new AverageIntTriCollector<A, B, C>(mapper);
    }

    public static <A, B, C> TriConstraintCollector<A, B, C, ?, Double> average(ToLongTriFunction<? super A, ? super B, ? super C> mapper) {
        return new AverageLongTriCollector<A, B, C>(mapper);
    }

    static <A, B, C, Mapped_, Average_> TriConstraintCollector<A, B, C, ?, Average_> average(TriFunction<? super A, ? super B, ? super C, ? extends Mapped_> mapper, Supplier<ReferenceAverageCalculator<Mapped_, Average_>> calculatorSupplier) {
        return new AverageReferenceTriCollector<A, B, C, Mapped_, Average_>(mapper, calculatorSupplier);
    }

    public static <A, B, C> TriConstraintCollector<A, B, C, ?, BigDecimal> averageBigDecimal(TriFunction<? super A, ? super B, ? super C, ? extends BigDecimal> mapper) {
        return InnerTriConstraintCollectors.average(mapper, ReferenceAverageCalculator.bigDecimal());
    }

    public static <A, B, C> TriConstraintCollector<A, B, C, ?, BigDecimal> averageBigInteger(TriFunction<? super A, ? super B, ? super C, ? extends BigInteger> mapper) {
        return InnerTriConstraintCollectors.average(mapper, ReferenceAverageCalculator.bigInteger());
    }

    public static <A, B, C> TriConstraintCollector<A, B, C, ?, Duration> averageDuration(TriFunction<? super A, ? super B, ? super C, ? extends Duration> mapper) {
        return InnerTriConstraintCollectors.average(mapper, ReferenceAverageCalculator.duration());
    }

    public static <A, B, C, ResultHolder1_, ResultHolder2_, ResultHolder3_, ResultHolder4_, Result1_, Result2_, Result3_, Result4_, Result_> TriConstraintCollector<A, B, C, ?, Result_> compose(TriConstraintCollector<A, B, C, ResultHolder1_, Result1_> first, TriConstraintCollector<A, B, C, ResultHolder2_, Result2_> second, TriConstraintCollector<A, B, C, ResultHolder3_, Result3_> third, TriConstraintCollector<A, B, C, ResultHolder4_, Result4_> fourth, QuadFunction<Result1_, Result2_, Result3_, Result4_, Result_> composeFunction) {
        return new ComposeFourTriCollector<A, B, C, ResultHolder1_, ResultHolder2_, ResultHolder3_, ResultHolder4_, Result1_, Result2_, Result3_, Result4_, Result_>(first, second, third, fourth, composeFunction);
    }

    public static <A, B, C, ResultHolder1_, ResultHolder2_, ResultHolder3_, Result1_, Result2_, Result3_, Result_> TriConstraintCollector<A, B, C, ?, Result_> compose(TriConstraintCollector<A, B, C, ResultHolder1_, Result1_> first, TriConstraintCollector<A, B, C, ResultHolder2_, Result2_> second, TriConstraintCollector<A, B, C, ResultHolder3_, Result3_> third, TriFunction<Result1_, Result2_, Result3_, Result_> composeFunction) {
        return new ComposeThreeTriCollector<A, B, C, ResultHolder1_, ResultHolder2_, ResultHolder3_, Result1_, Result2_, Result3_, Result_>(first, second, third, composeFunction);
    }

    public static <A, B, C, ResultHolder1_, ResultHolder2_, Result1_, Result2_, Result_> TriConstraintCollector<A, B, C, ?, Result_> compose(TriConstraintCollector<A, B, C, ResultHolder1_, Result1_> first, TriConstraintCollector<A, B, C, ResultHolder2_, Result2_> second, BiFunction<Result1_, Result2_, Result_> composeFunction) {
        return new ComposeTwoTriCollector<A, B, C, ResultHolder1_, ResultHolder2_, Result1_, Result2_, Result_>(first, second, composeFunction);
    }

    public static <A, B, C, ResultContainer_, Result_> TriConstraintCollector<A, B, C, ResultContainer_, Result_> conditionally(TriPredicate<A, B, C> predicate, TriConstraintCollector<A, B, C, ResultContainer_, Result_> delegate) {
        return new ConditionalTriCollector<A, B, C, ResultContainer_, Result_>(predicate, delegate);
    }

    public static <A, B, C> TriConstraintCollector<A, B, C, ?, Integer> count() {
        return CountIntTriCollector.getInstance();
    }

    public static <A, B, C, Mapped_> TriConstraintCollector<A, B, C, ?, Integer> countDistinct(TriFunction<? super A, ? super B, ? super C, ? extends Mapped_> mapper) {
        return new CountDistinctIntTriCollector<A, B, C, Mapped_>(mapper);
    }

    public static <A, B, C, Mapped_> TriConstraintCollector<A, B, C, ?, Long> countDistinctLong(TriFunction<? super A, ? super B, ? super C, ? extends Mapped_> mapper) {
        return new CountDistinctLongTriCollector<A, B, C, Mapped_>(mapper);
    }

    public static <A, B, C> TriConstraintCollector<A, B, C, ?, Long> countLong() {
        return CountLongTriCollector.getInstance();
    }

    public static <A, B, C, Result_ extends Comparable<? super Result_>> TriConstraintCollector<A, B, C, ?, Result_> max(TriFunction<? super A, ? super B, ? super C, ? extends Result_> mapper) {
        return new MaxComparableTriCollector<A, B, C, Result_>(mapper);
    }

    public static <A, B, C, Result_> TriConstraintCollector<A, B, C, ?, Result_> max(TriFunction<? super A, ? super B, ? super C, ? extends Result_> mapper, Comparator<? super Result_> comparator) {
        return new MaxComparatorTriCollector<A, B, C, Result_>(mapper, comparator);
    }

    public static <A, B, C, Result_, Property_ extends Comparable<? super Property_>> TriConstraintCollector<A, B, C, ?, Result_> max(TriFunction<? super A, ? super B, ? super C, ? extends Result_> mapper, Function<? super Result_, ? extends Property_> propertyMapper) {
        return new MaxPropertyTriCollector<A, B, C, Result_, Property_>(mapper, propertyMapper);
    }

    public static <A, B, C, Result_ extends Comparable<? super Result_>> TriConstraintCollector<A, B, C, ?, Result_> min(TriFunction<? super A, ? super B, ? super C, ? extends Result_> mapper) {
        return new MinComparableTriCollector<A, B, C, Result_>(mapper);
    }

    public static <A, B, C, Result_> TriConstraintCollector<A, B, C, ?, Result_> min(TriFunction<? super A, ? super B, ? super C, ? extends Result_> mapper, Comparator<? super Result_> comparator) {
        return new MinComparatorTriCollector<A, B, C, Result_>(mapper, comparator);
    }

    public static <A, B, C, Result_, Property_ extends Comparable<? super Property_>> TriConstraintCollector<A, B, C, ?, Result_> min(TriFunction<? super A, ? super B, ? super C, ? extends Result_> mapper, Function<? super Result_, ? extends Property_> propertyMapper) {
        return new MinPropertyTriCollector<A, B, C, Result_, Property_>(mapper, propertyMapper);
    }

    public static <A, B, C> TriConstraintCollector<A, B, C, ?, Integer> sum(ToIntTriFunction<? super A, ? super B, ? super C> mapper) {
        return new SumIntTriCollector<A, B, C>(mapper);
    }

    public static <A, B, C> TriConstraintCollector<A, B, C, ?, Long> sum(ToLongTriFunction<? super A, ? super B, ? super C> mapper) {
        return new SumLongTriCollector<A, B, C>(mapper);
    }

    public static <A, B, C, Result_> TriConstraintCollector<A, B, C, ?, Result_> sum(TriFunction<? super A, ? super B, ? super C, ? extends Result_> mapper, Result_ zero, BinaryOperator<Result_> adder, BinaryOperator<Result_> subtractor) {
        return new SumReferenceTriCollector<A, B, C, Result_>(mapper, zero, adder, subtractor);
    }

    public static <A, B, C, Mapped_, Result_ extends Collection<Mapped_>> TriConstraintCollector<A, B, C, ?, Result_> toCollection(TriFunction<? super A, ? super B, ? super C, ? extends Mapped_> mapper, IntFunction<Result_> collectionFunction) {
        return new ToCollectionTriCollector<A, B, C, Mapped_, Result_>(mapper, collectionFunction);
    }

    public static <A, B, C, Mapped_> TriConstraintCollector<A, B, C, ?, List<Mapped_>> toList(TriFunction<? super A, ? super B, ? super C, ? extends Mapped_> mapper) {
        return new ToListTriCollector<A, B, C, Mapped_>(mapper);
    }

    public static <A, B, C, Key_, Value_, Set_ extends Set<Value_>, Result_ extends Map<Key_, Set_>> TriConstraintCollector<A, B, C, ?, Result_> toMap(TriFunction<? super A, ? super B, ? super C, ? extends Key_> keyFunction, TriFunction<? super A, ? super B, ? super C, ? extends Value_> valueFunction, Supplier<Result_> mapSupplier, IntFunction<Set_> setFunction) {
        return new ToMultiMapTriCollector<A, B, C, Key_, Value_, Set_, Result_>(keyFunction, valueFunction, mapSupplier, setFunction);
    }

    public static <A, B, C, Key_, Value_, Result_ extends Map<Key_, Value_>> TriConstraintCollector<A, B, C, ?, Result_> toMap(TriFunction<? super A, ? super B, ? super C, ? extends Key_> keyFunction, TriFunction<? super A, ? super B, ? super C, ? extends Value_> valueFunction, Supplier<Result_> mapSupplier, BinaryOperator<Value_> mergeFunction) {
        return new ToSimpleMapTriCollector<A, B, C, Key_, Value_, Result_>(keyFunction, valueFunction, mapSupplier, mergeFunction);
    }

    public static <A, B, C, Mapped_> TriConstraintCollector<A, B, C, ?, Set<Mapped_>> toSet(TriFunction<? super A, ? super B, ? super C, ? extends Mapped_> mapper) {
        return new ToSetTriCollector<A, B, C, Mapped_>(mapper);
    }

    public static <A, B, C, Mapped_> TriConstraintCollector<A, B, C, ?, SortedSet<Mapped_>> toSortedSet(TriFunction<? super A, ? super B, ? super C, ? extends Mapped_> mapper, Comparator<? super Mapped_> comparator) {
        return new ToSortedSetComparatorTriCollector<A, B, C, Mapped_>(mapper, comparator);
    }

    public static <A, B, C, Result_> TriConstraintCollector<A, B, C, ?, SequenceChain<Result_, Integer>> toConsecutiveSequences(TriFunction<A, B, C, Result_> resultMap, ToIntFunction<Result_> indexMap) {
        return new ConsecutiveSequencesTriConstraintCollector<A, B, C, Result_>(resultMap, indexMap);
    }

    public static <A, B, C, Interval_, Point_ extends Comparable<Point_>, Difference_ extends Comparable<Difference_>> TriConstraintCollector<A, B, C, ?, ConnectedRangeChain<Interval_, Point_, Difference_>> toConnectedRanges(TriFunction<? super A, ? super B, ? super C, ? extends Interval_> mapper, Function<? super Interval_, ? extends Point_> startMap, Function<? super Interval_, ? extends Point_> endMap, BiFunction<? super Point_, ? super Point_, ? extends Difference_> differenceFunction) {
        return new ConnectedRangesTriConstraintCollector<A, B, C, Interval_, Point_, Difference_>(mapper, startMap, endMap, differenceFunction);
    }

    public static <A, B, C, Intermediate_, Result_> TriConstraintCollector<A, B, C, ?, Result_> collectAndThen(TriConstraintCollector<A, B, C, ?, Intermediate_> delegate, Function<Intermediate_, Result_> mappingFunction) {
        return new AndThenTriCollector(delegate, mappingFunction);
    }

    public static <A, B, C, Balanced_> TriConstraintCollector<A, B, C, ?, LoadBalance<Balanced_>> loadBalance(TriFunction<A, B, C, Balanced_> balancedItemFunction, ToLongTriFunction<A, B, C> loadFunction, ToLongTriFunction<A, B, C> initialLoadFunction) {
        return new LoadBalanceTriCollector<A, B, C, Balanced_>(balancedItemFunction, loadFunction, initialLoadFunction);
    }
}

