/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector.bi;

import ai.timefold.solver.core.api.function.TriFunction;
import ai.timefold.solver.core.api.score.stream.bi.BiConstraintCollector;
import ai.timefold.solver.core.impl.score.stream.collector.ObjectCalculator;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class ObjectCalculatorBiCollector<A, B, Input_, Output_, Mapped_, Calculator_ extends ObjectCalculator<Input_, Output_, Mapped_>>
implements BiConstraintCollector<A, B, Calculator_, Output_> {
    protected final BiFunction<? super A, ? super B, ? extends Input_> mapper;

    public ObjectCalculatorBiCollector(BiFunction<? super A, ? super B, ? extends Input_> mapper) {
        this.mapper = mapper;
    }

    @Override
    public @NonNull TriFunction<Calculator_, A, B, Runnable> accumulator() {
        return (calculator, a, b) -> {
            Input_ mapped = this.mapper.apply(a, b);
            Object saved = calculator.insert(mapped);
            return () -> calculator.retract(saved);
        };
    }

    @Override
    public @NonNull Function<Calculator_, Output_> finisher() {
        return ObjectCalculator::result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ObjectCalculatorBiCollector that = (ObjectCalculatorBiCollector)object;
        return Objects.equals(this.mapper, that.mapper);
    }

    public int hashCode() {
        return Objects.hash(this.mapper);
    }
}

