/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector;

import ai.timefold.solver.core.impl.score.stream.collector.UndoableActionable;
import ai.timefold.solver.core.impl.util.ConstantLambdaUtils;
import ai.timefold.solver.core.impl.util.MutableInt;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.Function;

public final class MinMaxUndoableActionable<Result_, Property_>
implements UndoableActionable<Result_, Result_> {
    private final boolean isMin;
    private final NavigableMap<Property_, Map<Result_, MutableInt>> propertyToItemCountMap;
    private final Function<? super Result_, ? extends Property_> propertyFunction;

    private MinMaxUndoableActionable(boolean isMin, NavigableMap<Property_, Map<Result_, MutableInt>> propertyToItemCountMap, Function<? super Result_, ? extends Property_> propertyFunction) {
        this.isMin = isMin;
        this.propertyToItemCountMap = propertyToItemCountMap;
        this.propertyFunction = propertyFunction;
    }

    public static <Result extends Comparable<? super Result>> MinMaxUndoableActionable<Result, Result> minCalculator() {
        return new MinMaxUndoableActionable(true, new TreeMap(), ConstantLambdaUtils.identity());
    }

    public static <Result extends Comparable<? super Result>> MinMaxUndoableActionable<Result, Result> maxCalculator() {
        return new MinMaxUndoableActionable(false, new TreeMap(), ConstantLambdaUtils.identity());
    }

    public static <Result> MinMaxUndoableActionable<Result, Result> minCalculator(Comparator<? super Result> comparator) {
        return new MinMaxUndoableActionable(true, new TreeMap(comparator), ConstantLambdaUtils.identity());
    }

    public static <Result> MinMaxUndoableActionable<Result, Result> maxCalculator(Comparator<? super Result> comparator) {
        return new MinMaxUndoableActionable(false, new TreeMap(comparator), ConstantLambdaUtils.identity());
    }

    public static <Result, Property extends Comparable<? super Property>> MinMaxUndoableActionable<Result, Property> minCalculator(Function<? super Result, ? extends Property> propertyMapper) {
        return new MinMaxUndoableActionable<Result, Property>(true, new TreeMap(), propertyMapper);
    }

    public static <Result, Property extends Comparable<? super Property>> MinMaxUndoableActionable<Result, Property> maxCalculator(Function<? super Result, ? extends Property> propertyMapper) {
        return new MinMaxUndoableActionable<Result, Property>(false, new TreeMap(), propertyMapper);
    }

    @Override
    public Runnable insert(Result_ item) {
        Property_ key = this.propertyFunction.apply(item);
        Map itemCountMap = this.propertyToItemCountMap.computeIfAbsent(key, ignored -> new LinkedHashMap());
        MutableInt count = itemCountMap.computeIfAbsent(item, ignored -> new MutableInt());
        count.increment();
        return () -> {
            if (count.decrement() == 0) {
                itemCountMap.remove(item);
                if (itemCountMap.isEmpty()) {
                    this.propertyToItemCountMap.remove(key);
                }
            }
        };
    }

    @Override
    public Result_ result() {
        if (this.propertyToItemCountMap.isEmpty()) {
            return null;
        }
        return this.isMin ? MinMaxUndoableActionable.getFirstKey(this.propertyToItemCountMap.firstEntry().getValue()) : MinMaxUndoableActionable.getFirstKey(this.propertyToItemCountMap.lastEntry().getValue());
    }

    private static <Key_> Key_ getFirstKey(Map<Key_, ?> map) {
        return map.keySet().iterator().next();
    }
}

