/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet.tri;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.bavet.common.AbstractConcatNode;
import ai.timefold.solver.core.impl.bavet.common.BavetAbstractConstraintStream;
import ai.timefold.solver.core.impl.bavet.common.tuple.TriTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.bavet.tri.ConcatBiTriNode;
import ai.timefold.solver.core.impl.bavet.tri.ConcatTriBiNode;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraintFactory;
import ai.timefold.solver.core.impl.score.stream.bavet.common.BavetConcatConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.common.ConstraintNodeBuildHelper;
import ai.timefold.solver.core.impl.score.stream.bavet.common.bridge.BavetForeBridgeBiConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.common.bridge.BavetForeBridgeTriConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.tri.BavetAbstractTriConstraintStream;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;

public final class BavetBiConcatTriConstraintStream<Solution_, A, B, C>
extends BavetAbstractTriConstraintStream<Solution_, A, B, C>
implements BavetConcatConstraintStream<Solution_> {
    private final BavetAbstractConstraintStream<Solution_> leftParent;
    private final BavetAbstractConstraintStream<Solution_> rightParent;
    private final BiFunction<A, B, C> paddingFunction;
    private final ConcatNodeConstructor<A, B, C> nodeConstructor;

    public BavetBiConcatTriConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetForeBridgeBiConstraintStream<Solution_, A, B> leftParent, BavetForeBridgeTriConstraintStream<Solution_, A, B, C> rightParent, BiFunction<A, B, C> paddingFunction) {
        super(constraintFactory, leftParent.getRetrievalSemantics());
        this.leftParent = leftParent;
        this.rightParent = rightParent;
        this.paddingFunction = paddingFunction;
        this.nodeConstructor = ConcatBiTriNode::new;
    }

    public BavetBiConcatTriConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetForeBridgeTriConstraintStream<Solution_, A, B, C> leftParent, BavetForeBridgeBiConstraintStream<Solution_, A, B> rightParent, BiFunction<A, B, C> paddingFunction) {
        super(constraintFactory, leftParent.getRetrievalSemantics());
        this.leftParent = leftParent;
        this.rightParent = rightParent;
        this.paddingFunction = paddingFunction;
        this.nodeConstructor = ConcatTriBiNode::new;
    }

    @Override
    public boolean guaranteesDistinct() {
        return this.leftParent.guaranteesDistinct() && this.rightParent.guaranteesDistinct();
    }

    @Override
    public void collectActiveConstraintStreams(Set<BavetAbstractConstraintStream<Solution_>> constraintStreamSet) {
        this.leftParent.collectActiveConstraintStreams(constraintStreamSet);
        this.rightParent.collectActiveConstraintStreams(constraintStreamSet);
        constraintStreamSet.add(this);
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(ConstraintNodeBuildHelper<Solution_, Score_> buildHelper) {
        TupleLifecycle downstream = buildHelper.getAggregatedTupleLifecycle(this.childStreamList);
        int leftCloneStoreIndex = buildHelper.reserveTupleStoreIndex(this.leftParent.getTupleSource());
        int rightCloneStoreIndex = buildHelper.reserveTupleStoreIndex(this.rightParent.getTupleSource());
        int outputStoreSize = buildHelper.extractTupleStoreSize(this);
        AbstractConcatNode<?, ?, ?> node = this.nodeConstructor.apply(this.paddingFunction, downstream, leftCloneStoreIndex, rightCloneStoreIndex, outputStoreSize);
        buildHelper.addNode(node, this, this.leftParent, this.rightParent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BavetBiConcatTriConstraintStream other = (BavetBiConcatTriConstraintStream)o;
        return Objects.equals(this.leftParent.getParent(), other.leftParent.getParent()) && Objects.equals(this.rightParent.getParent(), other.rightParent.getParent());
    }

    public int hashCode() {
        return Objects.hash(this.leftParent.getParent(), this.rightParent.getParent());
    }

    public String toString() {
        return "BiConcat() with " + this.childStreamList.size() + " children";
    }

    @Override
    public BavetAbstractConstraintStream<Solution_> getLeftParent() {
        return this.leftParent;
    }

    @Override
    public BavetAbstractConstraintStream<Solution_> getRightParent() {
        return this.rightParent;
    }

    private static interface ConcatNodeConstructor<A, B, C> {
        public AbstractConcatNode<?, ?, ?> apply(BiFunction<A, B, C> var1, TupleLifecycle<TriTuple<A, B, C>> var2, int var3, int var4, int var5);
    }
}

