/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.director;

import ai.timefold.solver.core.api.score.Score;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;

@NullMarked
public record InnerScore<Score_ extends Score<Score_>>(Score_ raw, int unassignedCount) implements Comparable<InnerScore<Score_>>
{
    public InnerScore {
        Objects.requireNonNull(raw);
        if (unassignedCount < 0) {
            throw new IllegalArgumentException("The unassignedCount (%d) must be >= 0.".formatted(unassignedCount));
        }
    }

    public static <Score_ extends Score<Score_>> InnerScore<Score_> fullyAssigned(Score_ score) {
        return new InnerScore<Score_>(score, 0);
    }

    public static <Score_ extends Score<Score_>> InnerScore<Score_> withUnassignedCount(Score_ score, int unassignedCount) {
        return new InnerScore<Score_>(score, unassignedCount);
    }

    public boolean isFullyAssigned() {
        return this.unassignedCount == 0;
    }

    @Override
    public int compareTo(InnerScore<Score_> other) {
        int uninitializedCountComparison = Integer.compare(this.unassignedCount, other.unassignedCount);
        if (uninitializedCountComparison != 0) {
            return -uninitializedCountComparison;
        }
        return this.raw.compareTo(other.raw);
    }

    @Override
    public String toString() {
        return this.isFullyAssigned() ? this.raw.toString() : "-%dinit/%s".formatted(this.unassignedCount, this.raw);
    }
}

