/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.phase;

import ai.timefold.solver.core.config.constructionheuristic.ConstructionHeuristicPhaseConfig;
import ai.timefold.solver.core.config.exhaustivesearch.ExhaustiveSearchPhaseConfig;
import ai.timefold.solver.core.config.localsearch.LocalSearchPhaseConfig;
import ai.timefold.solver.core.config.partitionedsearch.PartitionedSearchPhaseConfig;
import ai.timefold.solver.core.config.phase.PhaseConfig;
import ai.timefold.solver.core.config.phase.custom.CustomPhaseConfig;
import ai.timefold.solver.core.config.solver.termination.TerminationConfig;
import ai.timefold.solver.core.impl.constructionheuristic.scope.ConstructionHeuristicPhaseScope;
import ai.timefold.solver.core.impl.exhaustivesearch.scope.ExhaustiveSearchPhaseScope;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchPhaseScope;
import ai.timefold.solver.core.impl.phase.NoChangePhaseFactory;
import ai.timefold.solver.core.impl.phase.PhaseFactory;
import ai.timefold.solver.core.impl.phase.custom.scope.CustomPhaseScope;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.solver.termination.PhaseTermination;
import ai.timefold.solver.core.impl.solver.termination.SolverTermination;
import ai.timefold.solver.core.impl.solver.termination.TerminationFactory;
import ai.timefold.solver.core.impl.solver.termination.UniversalTermination;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPhaseFactory<Solution_, PhaseConfig_ extends PhaseConfig<PhaseConfig_>>
implements PhaseFactory<Solution_> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final PhaseConfig_ phaseConfig;

    public AbstractPhaseFactory(PhaseConfig_ phaseConfig) {
        this.phaseConfig = phaseConfig;
    }

    protected PhaseTermination<Solution_> buildPhaseTermination(HeuristicConfigPolicy<Solution_> configPolicy, SolverTermination<Solution_> solverTermination) {
        List<Object> list;
        TerminationConfig terminationConfig_ = Objects.requireNonNullElseGet(((PhaseConfig)this.phaseConfig).getTerminationConfig(), TerminationConfig::new);
        PhaseTermination<Solution_> phaseTermination = PhaseTermination.bridge(solverTermination);
        PhaseTermination<Solution_> resultingTermination = TerminationFactory.create(terminationConfig_).buildTermination(configPolicy, phaseTermination);
        if (!(this instanceof NoChangePhaseFactory) && resultingTermination instanceof UniversalTermination) {
            UniversalTermination universalTermination = (UniversalTermination)resultingTermination;
            list = universalTermination.getPhaseTerminationsInapplicableTo(this.getPhaseScopeClass());
        } else {
            list = Collections.emptyList();
        }
        List inapplicableTerminationList = list;
        String phaseName = this.getClass().getSimpleName().replace("PhaseFactory", "").replace("Default", "");
        if (solverTermination != resultingTermination) {
            if (!inapplicableTerminationList.isEmpty()) {
                throw new IllegalStateException("The phase (%s) configured with terminations (%s) includes some terminations which are not applicable to it (%s).\nMaybe remove these terminations from the phase's configuration.".formatted(phaseName, phaseTermination, inapplicableTerminationList));
            }
        } else if (!inapplicableTerminationList.isEmpty()) {
            this.logger.trace("The solver-level termination ({}) includes phase-level terminations ({}) which are not applicable to the phase ({}).\nThese phase-level terminations will not take effect in this phase.", new Object[]{solverTermination, inapplicableTerminationList, phaseName});
        }
        return resultingTermination;
    }

    private Class<? extends AbstractPhaseScope> getPhaseScopeClass() {
        if (this.phaseConfig instanceof ConstructionHeuristicPhaseConfig) {
            return ConstructionHeuristicPhaseScope.class;
        }
        if (this.phaseConfig instanceof CustomPhaseConfig) {
            return CustomPhaseScope.class;
        }
        if (this.phaseConfig instanceof LocalSearchPhaseConfig) {
            return LocalSearchPhaseScope.class;
        }
        if (this.phaseConfig instanceof ExhaustiveSearchPhaseConfig) {
            return ExhaustiveSearchPhaseScope.class;
        }
        if (this.phaseConfig instanceof PartitionedSearchPhaseConfig) {
            try {
                return Class.forName("ai.timefold.solver.enterprise.core.partitioned.PartitionedSearchPhaseScope");
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("The class (%s) is not found.\nMake sure Timefold Solver Enterprise Edition is on the classpath, or disable partitioned search.\n".formatted("ai.timefold.solver.enterprise.core.partitioned.PartitionedSearchPhaseScope"));
            }
        }
        throw new IllegalStateException("Unsupported phaseConfig class: %s".formatted(this.phaseConfig.getClass()));
    }
}

