/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.phase;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.config.solver.monitoring.SolverMetric;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.phase.Phase;
import ai.timefold.solver.core.impl.phase.event.PhaseLifecycleListener;
import ai.timefold.solver.core.impl.phase.event.PhaseLifecycleSupport;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.phase.scope.AbstractStepScope;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import ai.timefold.solver.core.impl.score.director.InnerScore;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.score.director.SolutionInitializationStatistics;
import ai.timefold.solver.core.impl.solver.AbstractSolver;
import ai.timefold.solver.core.impl.solver.exception.ScoreCorruptionException;
import ai.timefold.solver.core.impl.solver.exception.VariableCorruptionException;
import ai.timefold.solver.core.impl.solver.monitoring.ScoreLevels;
import ai.timefold.solver.core.impl.solver.monitoring.SolverMetricUtil;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.solver.termination.PhaseTermination;
import ai.timefold.solver.core.impl.solver.termination.Termination;
import io.micrometer.core.instrument.Tags;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPhase<Solution_>
implements Phase<Solution_> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final int phaseIndex;
    protected final String logIndentation;
    protected final PhaseTermination<Solution_> phaseTermination;
    protected final boolean assertPhaseScoreFromScratch;
    protected final boolean assertStepScoreFromScratch;
    protected final boolean assertExpectedStepScore;
    protected final boolean assertShadowVariablesAreNotStaleAfterStep;
    protected PhaseLifecycleSupport<Solution_> phaseLifecycleSupport = new PhaseLifecycleSupport();

    protected AbstractPhase(AbstractPhaseBuilder<Solution_> builder) {
        this.phaseIndex = builder.phaseIndex;
        this.logIndentation = builder.logIndentation;
        this.phaseTermination = builder.phaseTermination;
        this.assertPhaseScoreFromScratch = builder.assertPhaseScoreFromScratch;
        this.assertStepScoreFromScratch = builder.assertStepScoreFromScratch;
        this.assertExpectedStepScore = builder.assertExpectedStepScore;
        this.assertShadowVariablesAreNotStaleAfterStep = builder.assertShadowVariablesAreNotStaleAfterStep;
    }

    public int getPhaseIndex() {
        return this.phaseIndex;
    }

    public Termination<Solution_> getPhaseTermination() {
        return this.phaseTermination;
    }

    public boolean isAssertStepScoreFromScratch() {
        return this.assertStepScoreFromScratch;
    }

    public boolean isAssertExpectedStepScore() {
        return this.assertExpectedStepScore;
    }

    public boolean isAssertShadowVariablesAreNotStaleAfterStep() {
        return this.assertShadowVariablesAreNotStaleAfterStep;
    }

    public abstract String getPhaseTypeString();

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        this.phaseLifecycleSupport.fireSolvingStarted(solverScope);
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        this.phaseLifecycleSupport.fireSolvingEnded(solverScope);
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        phaseScope.startingNow();
        phaseScope.reset();
        if (!this.isNested()) {
            AbstractSolver<Solution_> solver = phaseScope.getSolverScope().getSolver();
            solver.phaseStarted(phaseScope);
        }
        this.phaseTermination.phaseStarted(phaseScope);
        phaseScope.setTermination(this.phaseTermination);
        this.phaseLifecycleSupport.firePhaseStarted(phaseScope);
    }

    protected boolean isNested() {
        return false;
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        if (!this.isNested()) {
            AbstractSolver<Solution_> solver = phaseScope.getSolverScope().getSolver();
            solver.phaseEnded(phaseScope);
        }
        this.phaseTermination.phaseEnded(phaseScope);
        this.phaseLifecycleSupport.firePhaseEnded(phaseScope);
        if (this.assertPhaseScoreFromScratch) {
            InnerScore score = phaseScope.getSolverScope().calculateScore();
            try {
                phaseScope.assertWorkingScoreFromScratch(score, this.getPhaseTypeString() + " phase ended");
            }
            catch (ScoreCorruptionException | VariableCorruptionException e) {
                throw new IllegalStateException("Solver corruption was detected. Solutions provided by this solver can not be trusted.\nCorruptions typically arise from a bug in either your constraints or your variable listeners,\nbut they may also be caused by a rare solver bug.\nRun your solver with %s %s to find out more information about the error and if you are convinced that the problem is not in your code, please report a bug to Timefold.\nAt your own risk, you may run your solver with %s or %s instead to ignore this error.".formatted(new Object[]{EnvironmentMode.class.getSimpleName(), EnvironmentMode.FULL_ASSERT, EnvironmentMode.NO_ASSERT, EnvironmentMode.NON_REPRODUCIBLE}), e);
            }
        }
    }

    @Override
    public void stepStarted(AbstractStepScope<Solution_> stepScope) {
        if (!this.isNested()) {
            AbstractSolver<Solution_> solver = stepScope.getPhaseScope().getSolverScope().getSolver();
            solver.stepStarted(stepScope);
        }
        this.phaseTermination.stepStarted(stepScope);
        this.phaseLifecycleSupport.fireStepStarted(stepScope);
    }

    protected void calculateWorkingStepScore(AbstractStepScope<Solution_> stepScope, Object completedAction) {
        AbstractPhaseScope<Solution_> phaseScope = stepScope.getPhaseScope();
        InnerScore score = phaseScope.calculateScore();
        stepScope.setScore(score);
        if (this.assertStepScoreFromScratch) {
            phaseScope.assertWorkingScoreFromScratch(score, completedAction);
        }
        if (this.assertShadowVariablesAreNotStaleAfterStep) {
            phaseScope.assertShadowVariablesAreNotStale(score, completedAction);
        }
    }

    protected <Score_ extends Score<Score_>> void predictWorkingStepScore(AbstractStepScope<Solution_> stepScope, Object completedAction) {
        AbstractPhaseScope<Solution_> phaseScope = stepScope.getPhaseScope();
        phaseScope.getSolutionDescriptor().setScore(phaseScope.getWorkingSolution(), stepScope.getScore().raw());
        if (this.assertStepScoreFromScratch) {
            phaseScope.assertPredictedScoreFromScratch(stepScope.getScore(), completedAction);
        }
        if (this.assertExpectedStepScore) {
            phaseScope.assertExpectedWorkingScore(stepScope.getScore(), completedAction);
        }
        if (this.assertShadowVariablesAreNotStaleAfterStep) {
            phaseScope.assertShadowVariablesAreNotStale(stepScope.getScore(), completedAction);
        }
    }

    @Override
    public void stepEnded(AbstractStepScope<Solution_> stepScope) {
        if (!this.isNested()) {
            AbstractSolver<Solution_> solver = stepScope.getPhaseScope().getSolverScope().getSolver();
            solver.stepEnded(stepScope);
            AbstractPhase.collectMetrics(stepScope);
        }
        this.phaseTermination.stepEnded(stepScope);
        this.phaseLifecycleSupport.fireStepEnded(stepScope);
    }

    private static <Solution_> void collectMetrics(AbstractStepScope<Solution_> stepScope) {
        SolverScope<Solution_> solverScope = stepScope.getPhaseScope().getSolverScope();
        if (solverScope.isMetricEnabled(SolverMetric.STEP_SCORE) && stepScope.getScore().isFullyAssigned()) {
            Tags tags = solverScope.getMonitoringTags();
            ScoreDefinition scoreDefinition = solverScope.getScoreDefinition();
            Map<Tags, ScoreLevels> tagToScoreLevels = solverScope.getStepScoreMap();
            SolverMetricUtil.registerScore(SolverMetric.STEP_SCORE, tags, scoreDefinition, tagToScoreLevels, stepScope.getScore());
        }
    }

    @Override
    public void addPhaseLifecycleListener(PhaseLifecycleListener<Solution_> phaseLifecycleListener) {
        this.phaseLifecycleSupport.addEventListener(phaseLifecycleListener);
    }

    @Override
    public void removePhaseLifecycleListener(PhaseLifecycleListener<Solution_> phaseLifecycleListener) {
        this.phaseLifecycleSupport.removeEventListener(phaseLifecycleListener);
    }

    protected void assertWorkingSolutionInitialized(AbstractPhaseScope<Solution_> phaseScope) {
        if (!phaseScope.getStartingScore().isFullyAssigned()) {
            InnerScoreDirector scoreDirector = phaseScope.getScoreDirector();
            SolutionDescriptor<Solution_> solutionDescriptor = scoreDirector.getSolutionDescriptor();
            SolutionInitializationStatistics initializationStatistics = scoreDirector.getValueRangeManager().getInitializationStatistics();
            int uninitializedEntityCount = initializationStatistics.uninitializedEntityCount();
            if (uninitializedEntityCount > 0) {
                throw new IllegalStateException("%s phase (%d) needs to start from an initialized solution, but there are (%d) uninitialized entities.\nMaybe there is no Construction Heuristic configured before this phase to initialize the solution.\nOr maybe the getter/setters of your planning variables in your domain classes aren't implemented correctly.".formatted(this.getPhaseTypeString(), this.phaseIndex, uninitializedEntityCount));
            }
            int unassignedValueCount = initializationStatistics.unassignedValueCount();
            if (unassignedValueCount > 0) {
                throw new IllegalStateException("%s phase (%d) needs to start from an initialized solution, but planning list variable (%s) has (%d) unexpected unassigned values.\nMaybe there is no Construction Heuristic configured before this phase to initialize the solution.".formatted(this.getPhaseTypeString(), this.phaseIndex, solutionDescriptor.getListVariableDescriptor(), unassignedValueCount));
            }
        }
    }

    public static abstract class AbstractPhaseBuilder<Solution_> {
        private final int phaseIndex;
        private final String logIndentation;
        private final PhaseTermination<Solution_> phaseTermination;
        private boolean assertPhaseScoreFromScratch = false;
        private boolean assertStepScoreFromScratch = false;
        private boolean assertExpectedStepScore = false;
        private boolean assertShadowVariablesAreNotStaleAfterStep = false;

        protected AbstractPhaseBuilder(int phaseIndex, String logIndentation, PhaseTermination<Solution_> phaseTermination) {
            this.phaseIndex = phaseIndex;
            this.logIndentation = logIndentation;
            this.phaseTermination = phaseTermination;
        }

        public AbstractPhaseBuilder<Solution_> enableAssertions(EnvironmentMode environmentMode) {
            this.assertPhaseScoreFromScratch = environmentMode.isAsserted();
            this.assertStepScoreFromScratch = environmentMode.isFullyAsserted();
            this.assertExpectedStepScore = environmentMode.isIntrusivelyAsserted();
            this.assertShadowVariablesAreNotStaleAfterStep = environmentMode.isIntrusivelyAsserted();
            return this;
        }

        protected abstract AbstractPhase<Solution_> build();
    }
}

