/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.neighborhood.stream.enumerating.bi;

import ai.timefold.solver.core.impl.bavet.common.tuple.BiTuple;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.common.AbstractDataset;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.common.AbstractDatasetInstance;
import ai.timefold.solver.core.impl.util.CollectionUtils;
import ai.timefold.solver.core.impl.util.ElementAwareList;
import ai.timefold.solver.core.impl.util.ElementAwareListEntry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class BiDatasetInstance<Solution_, A, B>
extends AbstractDatasetInstance<Solution_, BiTuple<A, B>> {
    private final Map<A, ElementAwareList<BiTuple<A, B>>> tupleListMap = new LinkedHashMap<A, ElementAwareList<BiTuple<A, B>>>();

    public BiDatasetInstance(AbstractDataset<Solution_, BiTuple<A, B>> parent, int inputStoreIndex) {
        super(parent, inputStoreIndex);
    }

    @Override
    public void insert(BiTuple<A, B> tuple) {
        ElementAwareList tupleList = this.tupleListMap.computeIfAbsent(tuple.factA, key -> new ElementAwareList());
        ElementAwareListEntry<BiTuple<A, B>> entry = tupleList.add(tuple);
        tuple.setStore(this.inputStoreIndex, entry);
    }

    @Override
    public void update(BiTuple<A, B> tuple) {
        Object actualTupleList = tuple.getStore(this.inputStoreIndex);
        if (actualTupleList == null) {
            this.insert(tuple);
            return;
        }
        ElementAwareList<BiTuple<A, B>> expectedTupleList = this.tupleListMap.get(tuple.factA);
        if (actualTupleList == expectedTupleList) {
            return;
        }
        this.retract(tuple);
        this.insert(tuple);
    }

    @Override
    public void retract(BiTuple<A, B> tuple) {
        ElementAwareListEntry entry = (ElementAwareListEntry)tuple.removeStore(this.inputStoreIndex);
        if (entry != null) {
            ElementAwareList tupleList = entry.getList();
            entry.remove();
            if (tupleList.size() == 0) {
                this.tupleListMap.remove(tuple.factA);
            }
        }
    }

    @Override
    public Iterator<BiTuple<A, B>> iterator() {
        return new OriginalTupleMapIterator<A, B>(this.tupleListMap);
    }

    @Override
    public Iterator<BiTuple<A, B>> iterator(Random workingRandom) {
        return new RandomTupleMapIterator<A, B>(this.tupleListMap, workingRandom);
    }

    @NullMarked
    private static final class OriginalTupleMapIterator<A, B>
    implements Iterator<BiTuple<A, B>> {
        private final Iterator<ElementAwareList<BiTuple<A, B>>> listIterator;
        private @Nullable Iterator<BiTuple<A, B>> currentIterator = null;

        public OriginalTupleMapIterator(Map<A, ElementAwareList<BiTuple<A, B>>> tupleListMap) {
            this.listIterator = tupleListMap.values().iterator();
        }

        @Override
        public boolean hasNext() {
            while ((this.currentIterator == null || !this.currentIterator.hasNext()) && this.listIterator.hasNext()) {
                this.currentIterator = this.listIterator.next().iterator();
            }
            return this.currentIterator != null && this.currentIterator.hasNext();
        }

        @Override
        public BiTuple<A, B> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.currentIterator.next();
        }
    }

    @NullMarked
    private static final class RandomTupleMapIterator<A, B>
    implements Iterator<BiTuple<A, B>> {
        private final Random workingRandom;
        private final Map<A, ElementAwareList<BiTuple<A, B>>> allTuplesMap;
        private final List<A> keyList;
        private final Map<A, List<BiTuple<A, B>>> unvisitedTuplesMap;
        private @Nullable BiTuple<A, B> selection;

        public RandomTupleMapIterator(Map<A, ElementAwareList<BiTuple<A, B>>> allTuplesMap, Random workingRandom) {
            this.workingRandom = workingRandom;
            this.allTuplesMap = allTuplesMap;
            this.keyList = new ArrayList<A>(allTuplesMap.keySet());
            this.unvisitedTuplesMap = CollectionUtils.newHashMap(allTuplesMap.size());
        }

        @Override
        public boolean hasNext() {
            if (this.selection != null) {
                return true;
            }
            if (this.keyList.isEmpty()) {
                return false;
            }
            int randomKeyIndex = this.workingRandom.nextInt(this.keyList.size());
            A randomKey = this.keyList.get(randomKeyIndex);
            List<BiTuple<A, B>> randomAccessList = this.unvisitedTuplesMap.get(randomKey);
            if (randomAccessList == null) {
                ElementAwareList<BiTuple<A, B>> tupleList = this.allTuplesMap.get(randomKey);
                randomAccessList = new ArrayList<BiTuple<A, B>>(tupleList.size());
                tupleList.forEach(randomAccessList::add);
                this.unvisitedTuplesMap.put(randomKey, randomAccessList);
            }
            this.selection = randomAccessList.remove(this.workingRandom.nextInt(randomAccessList.size()));
            if (randomAccessList.isEmpty()) {
                this.unvisitedTuplesMap.remove(randomKey);
                this.keyList.remove(randomKeyIndex);
            }
            return true;
        }

        @Override
        public BiTuple<A, B> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            BiTuple<A, B> result = this.selection;
            this.selection = null;
            return result;
        }
    }
}

