/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.neighborhood.stream;

import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.MoveStreamFactory;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.stream.enumerating.BiEnumeratingStream;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.stream.enumerating.EnumeratingJoiners;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.stream.enumerating.UniEnumeratingStream;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.stream.enumerating.function.BiEnumeratingFilter;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.stream.enumerating.function.BiEnumeratingMapper;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.stream.enumerating.function.UniEnumeratingFilter;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.stream.sampling.BiSamplingStream;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.stream.sampling.UniSamplingStream;
import ai.timefold.solver.core.impl.neighborhood.stream.DefaultNeighborhoodSession;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.DatasetSession;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.DatasetSessionFactory;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.EnumeratingStreamFactory;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.bi.AbstractBiEnumeratingStream;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.uni.AbstractUniEnumeratingStream;
import ai.timefold.solver.core.impl.neighborhood.stream.sampling.DefaultBiFromBiSamplingStream;
import ai.timefold.solver.core.impl.neighborhood.stream.sampling.DefaultUniSamplingStream;
import ai.timefold.solver.core.impl.score.director.SessionContext;
import ai.timefold.solver.core.preview.api.domain.metamodel.ElementPosition;
import ai.timefold.solver.core.preview.api.domain.metamodel.GenuineVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningListVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningSolutionMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.PositionInList;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class DefaultMoveStreamFactory<Solution_>
implements MoveStreamFactory<Solution_> {
    private final EnumeratingStreamFactory<Solution_> enumeratingStreamFactory;
    private final DatasetSessionFactory<Solution_> datasetSessionFactory;
    private final Map<GenuineVariableMetaModel<Solution_, ?, ?>, NodeSharingSupportFunctions<Solution_, ?, ?>> nodeSharingSupportFunctionMap = new HashMap();
    private final Map<PlanningListVariableMetaModel<Solution_, ?, ?>, ListVariableNodeSharingSupportFunctions<Solution_, ?, ?>> listVariableNodeSharingSupportFunctionsMap = new HashMap();

    public DefaultMoveStreamFactory(SolutionDescriptor<Solution_> solutionDescriptor, EnvironmentMode environmentMode) {
        this.enumeratingStreamFactory = new EnumeratingStreamFactory<Solution_>(solutionDescriptor, environmentMode);
        this.datasetSessionFactory = new DatasetSessionFactory<Solution_>(this.enumeratingStreamFactory);
    }

    public DefaultNeighborhoodSession<Solution_> createSession(SessionContext<Solution_> context) {
        DatasetSession<Solution_> session = this.datasetSessionFactory.buildSession(context);
        return new DefaultNeighborhoodSession<Solution_>(session, context.solutionView());
    }

    @Override
    public PlanningSolutionMetaModel<Solution_> getSolutionMetaModel() {
        return this.enumeratingStreamFactory.getSolutionDescriptor().getMetaModel();
    }

    @Override
    public <A> UniEnumeratingStream<Solution_, A> forEach(Class<A> sourceClass, boolean includeNull) {
        EntityDescriptor<Solution_> entityDescriptor = this.getSolutionDescriptor().findEntityDescriptor(sourceClass);
        if (entityDescriptor == null) {
            return this.enumeratingStreamFactory.forEachNonDiscriminating(sourceClass, includeNull);
        }
        if (entityDescriptor.isGenuine()) {
            return this.enumeratingStreamFactory.forEachExcludingPinned(sourceClass, includeNull);
        }
        ListVariableDescriptor<Solution_> listVariableDescriptor = this.getSolutionDescriptor().getListVariableDescriptor();
        if (listVariableDescriptor == null) {
            return this.enumeratingStreamFactory.forEachNonDiscriminating(sourceClass, includeNull);
        }
        if (!listVariableDescriptor.supportsPinning()) {
            return this.enumeratingStreamFactory.forEachNonDiscriminating(sourceClass, includeNull);
        }
        if (!listVariableDescriptor.acceptsValueType(sourceClass)) {
            return this.enumeratingStreamFactory.forEachNonDiscriminating(sourceClass, includeNull);
        }
        return this.enumeratingStreamFactory.forEachExcludingPinned(sourceClass, includeNull);
    }

    @Override
    public <A> UniEnumeratingStream<Solution_, A> forEachUnfiltered(Class<A> sourceClass, boolean includeNull) {
        return this.enumeratingStreamFactory.forEachNonDiscriminating(sourceClass, includeNull);
    }

    @Override
    public <Entity_, Value_> BiEnumeratingStream<Solution_, Entity_, Value_> forEachEntityValuePair(GenuineVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel) {
        boolean bl;
        if (variableMetaModel instanceof PlanningVariableMetaModel) {
            PlanningVariableMetaModel planningVariableMetaModel = (PlanningVariableMetaModel)variableMetaModel;
            bl = planningVariableMetaModel.allowsUnassigned();
        } else {
            PlanningListVariableMetaModel planningListVariableMetaModel;
            bl = variableMetaModel instanceof PlanningListVariableMetaModel && (planningListVariableMetaModel = (PlanningListVariableMetaModel)variableMetaModel).allowsUnassignedValues();
        }
        boolean includeNull = bl;
        UniEnumeratingStream stream = this.enumeratingStreamFactory.forEachExcludingPinned(variableMetaModel.type(), includeNull);
        NodeSharingSupportFunctions<Solution_, Entity_, Value_> nodeSharingSupportFunctions = this.getNodeSharingSupportFunctions(variableMetaModel);
        return this.forEach(variableMetaModel.entity().type(), false).join(stream, EnumeratingJoiners.filtering(nodeSharingSupportFunctions.valueInRangeFilter));
    }

    private <Entity_, Value_> NodeSharingSupportFunctions<Solution_, Entity_, Value_> getNodeSharingSupportFunctions(GenuineVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel) {
        return this.nodeSharingSupportFunctionMap.computeIfAbsent(variableMetaModel, NodeSharingSupportFunctions::new);
    }

    @Override
    public <Entity_, Value_> UniEnumeratingStream<Solution_, ElementPosition> forEachAssignablePosition(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel) {
        UniEnumeratingStream unpinnedEntities = this.forEach(variableMetaModel.entity().type(), variableMetaModel.allowsUnassignedValues());
        ListVariableNodeSharingSupportFunctions<Solution_, Entity_, Value_> nodeSharingSupportFunctions = this.getNodeSharingSupportFunctions(variableMetaModel);
        UniEnumeratingStream unpinnedValues = this.forEach(variableMetaModel.type(), true).filter(nodeSharingSupportFunctions.unpinnedValueFilter);
        return unpinnedEntities.join(unpinnedValues, EnumeratingJoiners.filtering(nodeSharingSupportFunctions.valueInRangeFilter)).map(nodeSharingSupportFunctions.toElementPositionMapper).distinct();
    }

    private <Entity_, Value_> ListVariableNodeSharingSupportFunctions<Solution_, Entity_, Value_> getNodeSharingSupportFunctions(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel) {
        return this.listVariableNodeSharingSupportFunctionsMap.computeIfAbsent(variableMetaModel, ListVariableNodeSharingSupportFunctions::new);
    }

    @Override
    public <A> UniSamplingStream<Solution_, A> pick(UniEnumeratingStream<Solution_, A> enumeratingStream) {
        return new DefaultUniSamplingStream(((AbstractUniEnumeratingStream)enumeratingStream).createDataset());
    }

    @Override
    public <A, B> BiSamplingStream<Solution_, A, B> pick(BiEnumeratingStream<Solution_, A, B> enumeratingStream) {
        return new DefaultBiFromBiSamplingStream(((AbstractBiEnumeratingStream)enumeratingStream).createDataset());
    }

    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.enumeratingStreamFactory.getSolutionDescriptor();
    }

    private record NodeSharingSupportFunctions<Solution_, Entity_, Value_>(GenuineVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, BiEnumeratingFilter<Solution_, Entity_, Value_> valueInRangeFilter) {
        public NodeSharingSupportFunctions(GenuineVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel) {
            this(variableMetaModel, (solutionView, entity, value) -> solutionView.isValueInRange(variableMetaModel, entity, value));
        }
    }

    private record ListVariableNodeSharingSupportFunctions<Solution_, Entity_, Value_>(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, UniEnumeratingFilter<Solution_, Value_> unpinnedValueFilter, BiEnumeratingFilter<Solution_, Entity_, Value_> valueInRangeFilter, BiEnumeratingMapper<Solution_, Entity_, Value_, ElementPosition> toElementPositionMapper) {
        public ListVariableNodeSharingSupportFunctions(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel) {
            this(variableMetaModel, (solutionView, value) -> value == null || solutionView.getPositionOf(variableMetaModel, value) instanceof PositionInList, (solutionView, entity, value) -> {
                if (entity == null || value == null) {
                    return true;
                }
                return solutionView.isValueInRange(variableMetaModel, entity, value);
            }, (solutionView, entity, value) -> {
                if (entity == null) {
                    return ElementPosition.unassigned();
                }
                int valueCount = solutionView.countValues(variableMetaModel, entity);
                if (value == null || valueCount == 0) {
                    return ElementPosition.of(entity, valueCount);
                }
                return solutionView.getPositionOf(variableMetaModel, value);
            });
        }
    }
}

