/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.neighborhood.move;

import ai.timefold.solver.core.impl.bavet.common.tuple.UniTuple;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.NeighborhoodSession;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.move.BiMoveConstructor;
import ai.timefold.solver.core.impl.neighborhood.move.InnerMoveStream;
import ai.timefold.solver.core.impl.neighborhood.move.MoveIterable;
import ai.timefold.solver.core.impl.neighborhood.stream.DefaultNeighborhoodSession;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.common.AbstractEnumeratingStream;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.uni.UniDataset;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.uni.UniDatasetInstance;
import ai.timefold.solver.core.preview.api.move.Move;
import ai.timefold.solver.core.preview.api.move.SolutionView;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class FromUniBiMoveStream<Solution_, A, B>
implements InnerMoveStream<Solution_> {
    private final UniDataset<Solution_, A> aDataset;
    private final UniDataset<Solution_, B> bDataset;
    private final BiMoveConstructor<Solution_, A, B> moveConstructor;
    private final BiPredicate<A, B> filter;

    public FromUniBiMoveStream(UniDataset<Solution_, A> aDataset, UniDataset<Solution_, B> bDataset, BiPredicate<A, B> filter, BiMoveConstructor<Solution_, A, B> moveConstructor) {
        this.aDataset = Objects.requireNonNull(aDataset);
        this.bDataset = Objects.requireNonNull(bDataset);
        this.filter = Objects.requireNonNull(filter);
        this.moveConstructor = Objects.requireNonNull(moveConstructor);
    }

    @Override
    public MoveIterable<Solution_> getMoveIterable(NeighborhoodSession neighborhoodSession) {
        return new BiMoveIterable((DefaultNeighborhoodSession)neighborhoodSession);
    }

    @Override
    public void collectActiveEnumeratingStreams(Set<AbstractEnumeratingStream<Solution_>> enumeratingStreamSet) {
        this.aDataset.collectActiveEnumeratingStreams(enumeratingStreamSet);
        this.bDataset.collectActiveEnumeratingStreams(enumeratingStreamSet);
    }

    private final class BiMoveIterable
    implements MoveIterable<Solution_> {
        private final DefaultNeighborhoodSession<Solution_> neighborhoodSession;

        public BiMoveIterable(DefaultNeighborhoodSession<Solution_> neighborhoodSession) {
            this.neighborhoodSession = Objects.requireNonNull(neighborhoodSession);
        }

        @Override
        public Iterator<Move<Solution_>> iterator() {
            return new BiMoveIterator(this.neighborhoodSession);
        }

        @Override
        public Iterator<Move<Solution_>> iterator(Random random) {
            return new BiMoveIterator(this.neighborhoodSession, random);
        }
    }

    private final class BiMoveIterator
    implements Iterator<Move<Solution_>> {
        private final IteratorSupplier<A> aIteratorSupplier;
        private final IteratorSupplier<B> bIteratorSupplier;
        private final SolutionView<Solution_> solutionView;
        private @Nullable Move<Solution_> nextMove;
        private @Nullable Iterator<UniTuple<A>> aIterator;
        private @Nullable Iterator<UniTuple<B>> bIterator;
        private @Nullable A currentA;

        public BiMoveIterator(DefaultNeighborhoodSession<Solution_> neighborhoodSession) {
            UniDatasetInstance aInstance = neighborhoodSession.getDatasetInstance(FromUniBiMoveStream.this.aDataset);
            this.aIteratorSupplier = aInstance::iterator;
            UniDatasetInstance bInstance = neighborhoodSession.getDatasetInstance(FromUniBiMoveStream.this.bDataset);
            this.bIteratorSupplier = bInstance::iterator;
            this.solutionView = neighborhoodSession.getSolutionView();
        }

        public BiMoveIterator(DefaultNeighborhoodSession<Solution_> neighborhoodSession, Random random) {
            UniDatasetInstance aInstance = neighborhoodSession.getDatasetInstance(FromUniBiMoveStream.this.aDataset);
            this.aIteratorSupplier = () -> aInstance.iterator(random);
            UniDatasetInstance bInstance = neighborhoodSession.getDatasetInstance(FromUniBiMoveStream.this.bDataset);
            this.bIteratorSupplier = () -> bInstance.iterator(random);
            this.solutionView = neighborhoodSession.getSolutionView();
        }

        @Override
        public boolean hasNext() {
            if (this.nextMove != null) {
                return true;
            }
            if (this.aIterator == null) {
                this.aIterator = (Iterator)this.aIteratorSupplier.get();
                if (!this.aIterator.hasNext()) {
                    return false;
                }
                this.currentA = this.aIterator.next().factA;
                this.bIterator = (Iterator)this.bIteratorSupplier.get();
            }
            while (true) {
                if (this.bIterator.hasNext()) {
                    UniTuple bTuple = this.bIterator.next();
                    Object currentB = bTuple.factA;
                    if (!FromUniBiMoveStream.this.filter.test(this.currentA, currentB)) continue;
                    this.nextMove = FromUniBiMoveStream.this.moveConstructor.apply(this.solutionView, this.currentA, currentB);
                    return true;
                }
                if (!this.aIterator.hasNext()) break;
                this.currentA = this.aIterator.next().factA;
                this.bIterator = (Iterator)this.bIteratorSupplier.get();
            }
            return false;
        }

        @Override
        public Move<Solution_> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Move result = this.nextMove;
            this.nextMove = null;
            return result;
        }

        @FunctionalInterface
        private static interface IteratorSupplier<A>
        extends Supplier<Iterator<UniTuple<A>>> {
        }
    }
}

