/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.neighborhood.move;

import ai.timefold.solver.core.impl.bavet.common.tuple.BiTuple;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.NeighborhoodSession;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.move.BiMoveConstructor;
import ai.timefold.solver.core.impl.neighborhood.move.InnerMoveStream;
import ai.timefold.solver.core.impl.neighborhood.move.MoveIterable;
import ai.timefold.solver.core.impl.neighborhood.stream.DefaultNeighborhoodSession;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.bi.BiDataset;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.bi.BiDatasetInstance;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.common.AbstractEnumeratingStream;
import ai.timefold.solver.core.preview.api.move.Move;
import ai.timefold.solver.core.preview.api.move.SolutionView;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class FromBiUniMoveStream<Solution_, A, B>
implements InnerMoveStream<Solution_> {
    private final BiDataset<Solution_, A, B> aDataset;
    private final BiMoveConstructor<Solution_, A, B> moveConstructor;

    public FromBiUniMoveStream(BiDataset<Solution_, A, B> aDataset, BiMoveConstructor<Solution_, A, B> moveConstructor) {
        this.aDataset = Objects.requireNonNull(aDataset);
        this.moveConstructor = Objects.requireNonNull(moveConstructor);
    }

    @Override
    public MoveIterable<Solution_> getMoveIterable(NeighborhoodSession neighborhoodSession) {
        return new InnerMoveIterable((DefaultNeighborhoodSession)neighborhoodSession);
    }

    @Override
    public void collectActiveEnumeratingStreams(Set<AbstractEnumeratingStream<Solution_>> enumeratingStreamSet) {
        this.aDataset.collectActiveEnumeratingStreams(enumeratingStreamSet);
    }

    @NullMarked
    private final class InnerMoveIterable
    implements MoveIterable<Solution_> {
        private final DefaultNeighborhoodSession<Solution_> neighborhoodSession;

        public InnerMoveIterable(DefaultNeighborhoodSession<Solution_> neighborhoodSession) {
            this.neighborhoodSession = Objects.requireNonNull(neighborhoodSession);
        }

        @Override
        public Iterator<Move<Solution_>> iterator() {
            return new InnerMoveIterator(this.neighborhoodSession);
        }

        @Override
        public Iterator<Move<Solution_>> iterator(Random random) {
            return new InnerMoveIterator(this.neighborhoodSession, random);
        }
    }

    @NullMarked
    private final class InnerMoveIterator
    implements Iterator<Move<Solution_>> {
        private final IteratorSupplier<A, B> iteratorSupplier;
        private final SolutionView<Solution_> solutionView;
        private @Nullable Move<Solution_> nextMove;
        private @Nullable Iterator<BiTuple<A, B>> iterator;

        public InnerMoveIterator(DefaultNeighborhoodSession<Solution_> neighborhoodSession) {
            BiDatasetInstance aInstance = neighborhoodSession.getDatasetInstance(FromBiUniMoveStream.this.aDataset);
            this.iteratorSupplier = aInstance::iterator;
            this.solutionView = neighborhoodSession.getSolutionView();
        }

        public InnerMoveIterator(DefaultNeighborhoodSession<Solution_> neighborhoodSession, Random random) {
            BiDatasetInstance aInstance = neighborhoodSession.getDatasetInstance(FromBiUniMoveStream.this.aDataset);
            this.iteratorSupplier = () -> aInstance.iterator(random);
            this.solutionView = neighborhoodSession.getSolutionView();
        }

        @Override
        public boolean hasNext() {
            if (this.nextMove != null) {
                return true;
            }
            if (this.iterator == null) {
                this.iterator = (Iterator)this.iteratorSupplier.get();
            }
            if (!this.iterator.hasNext()) {
                return false;
            }
            BiTuple tuple = this.iterator.next();
            this.nextMove = FromBiUniMoveStream.this.moveConstructor.apply(this.solutionView, tuple.factA, tuple.factB);
            return true;
        }

        @Override
        public Move<Solution_> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Move result = this.nextMove;
            this.nextMove = null;
            return result;
        }

        @FunctionalInterface
        private static interface IteratorSupplier<A, B>
        extends Supplier<Iterator<BiTuple<A, B>>> {
        }
    }
}

