/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.neighborhood.maybeapi.move;

import ai.timefold.solver.core.impl.neighborhood.move.AbstractMove;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningListVariableMetaModel;
import ai.timefold.solver.core.preview.api.move.Move;
import ai.timefold.solver.core.preview.api.move.MutableSolutionView;
import ai.timefold.solver.core.preview.api.move.Rebaser;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class ListUnassignMove<Solution_, Entity_, Value_>
extends AbstractMove<Solution_> {
    private final PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel;
    private final Entity_ sourceEntity;
    private final int sourceIndex;
    private @Nullable Value_ unassignedValue;

    protected ListUnassignMove(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, Entity_ sourceEntity, int sourceIndex) {
        this.variableMetaModel = Objects.requireNonNull(variableMetaModel);
        this.sourceEntity = Objects.requireNonNull(sourceEntity);
        if (sourceIndex < 0) {
            throw new IllegalArgumentException("The sourceIndex (" + sourceIndex + ") must be greater than or equal to 0.");
        }
        this.sourceIndex = sourceIndex;
    }

    @Override
    public void execute(MutableSolutionView<Solution_> solutionView) {
        this.unassignedValue = solutionView.unassignValue(this.variableMetaModel, this.sourceEntity, this.sourceIndex);
    }

    @Override
    public Move<Solution_> rebase(Rebaser rebaser) {
        return new ListUnassignMove<Solution_, Entity_, Value_>(this.variableMetaModel, rebaser.rebase(this.sourceEntity), this.sourceIndex);
    }

    @Override
    public Collection<Entity_> extractPlanningEntities() {
        return Collections.singleton(this.sourceEntity);
    }

    @Override
    public Collection<Value_> extractPlanningValues() {
        return Collections.singleton(this.getUnassignedValue());
    }

    private Value_ getUnassignedValue() {
        if (this.unassignedValue == null) {
            this.unassignedValue = Objects.requireNonNull(ListUnassignMove.getVariableDescriptor(this.variableMetaModel).getElement(this.sourceEntity, this.sourceIndex));
        }
        return this.unassignedValue;
    }

    @Override
    public List<PlanningListVariableMetaModel<Solution_, Entity_, Value_>> variableMetaModels() {
        return Collections.singletonList(this.variableMetaModel);
    }

    public Entity_ getSourceEntity() {
        return this.sourceEntity;
    }

    public int getSourceIndex() {
        return this.sourceIndex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof ListUnassignMove)) return false;
        ListUnassignMove other = (ListUnassignMove)o;
        if (!Objects.equals(this.variableMetaModel, other.variableMetaModel)) return false;
        if (!Objects.equals(this.sourceEntity, other.sourceEntity)) return false;
        if (this.sourceIndex != other.sourceIndex) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.variableMetaModel, this.sourceEntity, this.sourceIndex);
    }

    @Override
    public String toString() {
        return String.format("%s {%s[%d] -> null}", this.getUnassignedValue(), this.sourceEntity, this.sourceIndex);
    }
}

