/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.neighborhood.maybeapi.move;

import ai.timefold.solver.core.impl.neighborhood.maybeapi.MoveDefinition;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.MoveStream;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.MoveStreamFactory;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.move.Moves;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.move.UniquePair;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.stream.enumerating.BiEnumeratingStream;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.stream.enumerating.EnumeratingJoiners;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.stream.enumerating.UniEnumeratingStream;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningListVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.PositionInList;
import ai.timefold.solver.core.preview.api.move.SolutionView;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ListSwapMoveDefinition<Solution_, Entity_, Value_>
implements MoveDefinition<Solution_> {
    private final PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel;

    public ListSwapMoveDefinition(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel) {
        this.variableMetaModel = Objects.requireNonNull(variableMetaModel);
    }

    @Override
    public MoveStream<Solution_> build(MoveStreamFactory<Solution_> moveStreamFactory) {
        UniEnumeratingStream<Solution_, Object> assignedValueStream = moveStreamFactory.forEach(this.variableMetaModel.type(), false).filter((solutionView, value) -> solutionView.getPositionOf(this.variableMetaModel, value) instanceof PositionInList);
        BiEnumeratingStream validAssignedValuePairStream = assignedValueStream.join(assignedValueStream, EnumeratingJoiners.filtering((solutionView, leftValue, rightValue) -> !Objects.equals(leftValue, rightValue)));
        BiEnumeratingStream validAssignedValueUniquePairStream = validAssignedValuePairStream.map((solutionView, leftValue, rightValue) -> new UniquePair<Object>(leftValue, rightValue)).distinct().map((solutionView, pair) -> FullElementPosition.of(this.variableMetaModel, solutionView, pair.first()), (solutionView, pair) -> FullElementPosition.of(this.variableMetaModel, solutionView, pair.second()));
        BiEnumeratingStream<Solution_, FullElementPosition, FullElementPosition> result = validAssignedValueUniquePairStream.filter((solutionView, leftPosition, rightPosition) -> solutionView.isValueInRange(this.variableMetaModel, rightPosition.entity(), leftPosition.value()) && solutionView.isValueInRange(this.variableMetaModel, leftPosition.entity(), rightPosition.value()));
        return moveStreamFactory.pick(result).asMove((solutionView, leftPosition, rightPosition) -> Moves.swap(leftPosition.elementPosition, rightPosition.elementPosition, this.variableMetaModel));
    }

    @NullMarked
    private record FullElementPosition<Entity_, Value_>(Value_ value, PositionInList elementPosition) {
        public static <Solution_, Entity_, Value_> FullElementPosition<Entity_, Value_> of(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, SolutionView<Solution_> solutionView, Value_ value) {
            PositionInList assignedElement = solutionView.getPositionOf(variableMetaModel, value).ensureAssigned();
            return new FullElementPosition<Entity_, Value_>(value, assignedElement);
        }

        public Entity_ entity() {
            return this.elementPosition.entity();
        }

        public int index() {
            return this.elementPosition.index();
        }
    }
}

