/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.neighborhood.maybeapi.move;

import ai.timefold.solver.core.impl.neighborhood.move.AbstractMove;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningListVariableMetaModel;
import ai.timefold.solver.core.preview.api.move.Move;
import ai.timefold.solver.core.preview.api.move.MutableSolutionView;
import ai.timefold.solver.core.preview.api.move.Rebaser;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class ListAssignMove<Solution_, Entity_, Value_>
extends AbstractMove<Solution_> {
    private final PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel;
    private final Value_ planningValue;
    private final Entity_ destinationEntity;
    private final int destinationIndex;

    ListAssignMove(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, Value_ planningValue, Entity_ destinationEntity, int destinationIndex) {
        this.variableMetaModel = Objects.requireNonNull(variableMetaModel);
        this.planningValue = Objects.requireNonNull(planningValue);
        this.destinationEntity = Objects.requireNonNull(destinationEntity);
        if (destinationIndex < 0) {
            throw new IllegalArgumentException("The destinationIndex (" + destinationIndex + ") must be greater than 0.");
        }
        this.destinationIndex = destinationIndex;
    }

    @Override
    public void execute(MutableSolutionView<Solution_> mutableSolutionView) {
        mutableSolutionView.assignValue(this.variableMetaModel, this.planningValue, this.destinationEntity, this.destinationIndex);
    }

    @Override
    public Move<Solution_> rebase(Rebaser rebaser) {
        return new ListAssignMove<Solution_, Entity_, Value_>(this.variableMetaModel, Objects.requireNonNull(rebaser.rebase(this.planningValue)), Objects.requireNonNull(rebaser.rebase(this.destinationEntity)), this.destinationIndex);
    }

    @Override
    public Collection<Entity_> extractPlanningEntities() {
        return List.of(this.destinationEntity);
    }

    @Override
    public Collection<Value_> extractPlanningValues() {
        return List.of(this.planningValue);
    }

    @Override
    public List<PlanningListVariableMetaModel<Solution_, Entity_, Value_>> variableMetaModels() {
        return List.of(this.variableMetaModel);
    }

    public Value_ getPlanningValue() {
        return this.planningValue;
    }

    public Entity_ getDestinationEntity() {
        return this.destinationEntity;
    }

    public int getDestinationIndex() {
        return this.destinationIndex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof ListAssignMove)) return false;
        ListAssignMove other = (ListAssignMove)o;
        if (!Objects.equals(this.variableMetaModel, other.variableMetaModel)) return false;
        if (!Objects.equals(this.planningValue, other.planningValue)) return false;
        if (!Objects.equals(this.destinationEntity, other.destinationEntity)) return false;
        if (this.destinationIndex != other.destinationIndex) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.variableMetaModel, this.planningValue, this.destinationEntity, this.destinationIndex);
    }

    @Override
    public String toString() {
        return String.format("%s {null -> %s[%d]}", this.planningValue, this.destinationEntity, this.destinationIndex);
    }
}

