/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.move.director;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.move.AbstractMove;
import ai.timefold.solver.core.impl.move.director.ChangeAction;
import ai.timefold.solver.core.impl.move.director.ListVariableAfterAssignmentAction;
import ai.timefold.solver.core.impl.move.director.ListVariableAfterChangeAction;
import ai.timefold.solver.core.impl.move.director.ListVariableAfterUnassignmentAction;
import ai.timefold.solver.core.impl.move.director.ListVariableBeforeAssignmentAction;
import ai.timefold.solver.core.impl.move.director.ListVariableBeforeChangeAction;
import ai.timefold.solver.core.impl.move.director.ListVariableBeforeUnassignmentAction;
import ai.timefold.solver.core.impl.move.director.TriggerVariableListenersAction;
import ai.timefold.solver.core.impl.move.director.VariableChangeAction;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.score.director.RevertableScoreDirector;
import ai.timefold.solver.core.impl.score.director.ValueRangeManager;
import ai.timefold.solver.core.impl.score.director.VariableDescriptorCache;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;

public final class VariableChangeRecordingScoreDirector<Solution_, Score_ extends Score<Score_>>
implements RevertableScoreDirector<Solution_> {
    private final InnerScoreDirector<Solution_, Score_> backingScoreDirector;
    private final List<ChangeAction<Solution_>> variableChanges;
    private final Map<Object, Integer> cache;

    public VariableChangeRecordingScoreDirector(ScoreDirector<Solution_> backingScoreDirector) {
        this(backingScoreDirector, true);
    }

    public VariableChangeRecordingScoreDirector(ScoreDirector<Solution_> backingScoreDirector, boolean requiresIndexCache) {
        this.backingScoreDirector = (InnerScoreDirector)backingScoreDirector;
        this.cache = requiresIndexCache ? new IdentityHashMap() : null;
        this.variableChanges = new LinkedList<ChangeAction<Solution_>>();
    }

    private VariableChangeRecordingScoreDirector(InnerScoreDirector<Solution_, Score_> backingScoreDirector, List<ChangeAction<Solution_>> variableChanges, Map<Object, Integer> cache) {
        this.backingScoreDirector = backingScoreDirector;
        this.variableChanges = variableChanges;
        this.cache = cache;
    }

    @Override
    public List<ChangeAction<Solution_>> copyChanges() {
        return List.copyOf(this.variableChanges);
    }

    @Override
    public void undoChanges() {
        int changeCount = this.variableChanges.size();
        if (changeCount == 0) {
            return;
        }
        ListIterator<ChangeAction<Solution_>> listIterator = this.variableChanges.listIterator(changeCount);
        while (listIterator.hasPrevious()) {
            ChangeAction<Solution_> changeAction = listIterator.previous();
            changeAction.undo(this.backingScoreDirector);
        }
        Objects.requireNonNull(this.backingScoreDirector).triggerVariableListeners();
        this.variableChanges.clear();
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    @Override
    public void beforeVariableChanged(VariableDescriptor<Solution_> variableDescriptor, Object entity) {
        this.variableChanges.add(new VariableChangeAction(entity, variableDescriptor.getValue(entity), variableDescriptor));
        if (this.backingScoreDirector != null) {
            this.backingScoreDirector.beforeVariableChanged(variableDescriptor, entity);
        }
    }

    @Override
    public void afterVariableChanged(VariableDescriptor<Solution_> variableDescriptor, Object entity) {
        if (this.backingScoreDirector != null) {
            this.backingScoreDirector.afterVariableChanged(variableDescriptor, entity);
        }
    }

    @Override
    public void beforeListVariableChanged(ListVariableDescriptor<Solution_> variableDescriptor, Object entity, int fromIndex, int toIndex) {
        if (this.cache != null) {
            this.cache.put(entity, fromIndex);
        }
        Object list = variableDescriptor.getValue(entity);
        this.variableChanges.add(new ListVariableBeforeChangeAction(entity, List.copyOf(list.subList(fromIndex, toIndex)), fromIndex, toIndex, variableDescriptor));
        if (this.backingScoreDirector != null) {
            this.backingScoreDirector.beforeListVariableChanged(variableDescriptor, entity, fromIndex, toIndex);
        }
    }

    @Override
    public void afterListVariableChanged(ListVariableDescriptor<Solution_> variableDescriptor, Object entity, int fromIndex, int toIndex) {
        Integer requiredFromIndex;
        if (this.cache != null && (requiredFromIndex = this.cache.remove(entity)) != fromIndex) {
            throw new IllegalArgumentException("The fromIndex of afterListVariableChanged (%d) must match the fromIndex of its beforeListVariableChanged counterpart (%d).\nMaybe check implementation of your %s.".formatted(fromIndex, requiredFromIndex, AbstractMove.class.getSimpleName()));
        }
        this.variableChanges.add(new ListVariableAfterChangeAction(entity, fromIndex, toIndex, variableDescriptor));
        if (this.backingScoreDirector != null) {
            this.backingScoreDirector.afterListVariableChanged(variableDescriptor, entity, fromIndex, toIndex);
        }
    }

    @Override
    public void beforeListVariableElementAssigned(ListVariableDescriptor<Solution_> variableDescriptor, Object element) {
        this.variableChanges.add(new ListVariableBeforeAssignmentAction<Solution_>(element, variableDescriptor));
        if (this.backingScoreDirector != null) {
            this.backingScoreDirector.beforeListVariableElementAssigned(variableDescriptor, element);
        }
    }

    @Override
    public void afterListVariableElementAssigned(ListVariableDescriptor<Solution_> variableDescriptor, Object element) {
        this.variableChanges.add(new ListVariableAfterAssignmentAction<Solution_>(element, variableDescriptor));
        if (this.backingScoreDirector != null) {
            this.backingScoreDirector.afterListVariableElementAssigned(variableDescriptor, element);
        }
    }

    @Override
    public void beforeListVariableElementUnassigned(ListVariableDescriptor<Solution_> variableDescriptor, Object element) {
        this.variableChanges.add(new ListVariableBeforeUnassignmentAction<Solution_>(element, variableDescriptor));
        if (this.backingScoreDirector != null) {
            this.backingScoreDirector.beforeListVariableElementUnassigned(variableDescriptor, element);
        }
    }

    @Override
    public void afterListVariableElementUnassigned(ListVariableDescriptor<Solution_> variableDescriptor, Object element) {
        this.variableChanges.add(new ListVariableAfterUnassignmentAction<Solution_>(element, variableDescriptor));
        if (this.backingScoreDirector != null) {
            this.backingScoreDirector.afterListVariableElementUnassigned(variableDescriptor, element);
        }
    }

    @Override
    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return Objects.requireNonNull(this.backingScoreDirector).getSolutionDescriptor();
    }

    @Override
    public ValueRangeManager<Solution_> getValueRangeManager() {
        return this.getBacking().getValueRangeManager();
    }

    public InnerScoreDirector<Solution_, Score_> getBacking() {
        return this.backingScoreDirector;
    }

    public VariableChangeRecordingScoreDirector<Solution_, Score_> getNonDelegating() {
        return new VariableChangeRecordingScoreDirector<Solution_, Score_>(null, this.variableChanges, this.cache);
    }

    @Override
    public Solution_ getWorkingSolution() {
        return Objects.requireNonNull(this.backingScoreDirector).getWorkingSolution();
    }

    @Override
    public VariableDescriptorCache<Solution_> getVariableDescriptorCache() {
        return Objects.requireNonNull(this.backingScoreDirector).getVariableDescriptorCache();
    }

    @Override
    public void triggerVariableListeners() {
        this.variableChanges.add(new TriggerVariableListenersAction());
        if (this.backingScoreDirector != null) {
            this.backingScoreDirector.triggerVariableListeners();
        }
    }

    @Override
    public <E> E lookUpWorkingObject(E externalObject) {
        return Objects.requireNonNull(this.backingScoreDirector).lookUpWorkingObject(externalObject);
    }

    @Override
    public <E> E lookUpWorkingObjectOrReturnNull(E externalObject) {
        return Objects.requireNonNull(this.backingScoreDirector).lookUpWorkingObjectOrReturnNull(externalObject);
    }
}

