/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.value.decorator;

import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.AbstractDemandEnabledSelector;
import ai.timefold.solver.core.impl.heuristic.selector.common.SelectionCacheLifecycleBridge;
import ai.timefold.solver.core.impl.heuristic.selector.common.SelectionCacheLifecycleListener;
import ai.timefold.solver.core.impl.heuristic.selector.value.IterableValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.ValueSelector;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public abstract class AbstractCachingValueSelector<Solution_>
extends AbstractDemandEnabledSelector<Solution_>
implements SelectionCacheLifecycleListener<Solution_>,
ValueSelector<Solution_> {
    protected final IterableValueSelector<Solution_> childValueSelector;
    protected final SelectionCacheType cacheType;
    protected List<Object> cachedValueList = null;

    protected AbstractCachingValueSelector(IterableValueSelector<Solution_> childValueSelector, SelectionCacheType cacheType) {
        this.childValueSelector = childValueSelector;
        this.cacheType = cacheType;
        if (childValueSelector.isNeverEnding()) {
            throw new IllegalStateException("The selector (" + String.valueOf(this) + ") has a childValueSelector (" + String.valueOf(childValueSelector) + ") with neverEnding (" + childValueSelector.isNeverEnding() + ").");
        }
        this.phaseLifecycleSupport.addEventListener(childValueSelector);
        if (cacheType.isNotCached()) {
            throw new IllegalArgumentException("The selector (" + String.valueOf(this) + ") does not support the cacheType (" + String.valueOf((Object)cacheType) + ").");
        }
        this.phaseLifecycleSupport.addEventListener(new SelectionCacheLifecycleBridge(cacheType, this));
    }

    public ValueSelector<Solution_> getChildValueSelector() {
        return this.childValueSelector;
    }

    @Override
    public SelectionCacheType getCacheType() {
        return this.cacheType;
    }

    @Override
    public void constructCache(SolverScope<Solution_> solverScope) {
        long childSize = this.childValueSelector.getSize();
        if (childSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The selector (" + String.valueOf(this) + ") has a childValueSelector (" + String.valueOf(this.childValueSelector) + ") with childSize (" + childSize + ") which is higher than Integer.MAX_VALUE.");
        }
        this.cachedValueList = new ArrayList<Object>((int)childSize);
        this.childValueSelector.iterator().forEachRemaining(this.cachedValueList::add);
        this.logger.trace("    Created cachedValueList: size ({}), valueSelector ({}).", (Object)this.cachedValueList.size(), (Object)this);
    }

    @Override
    public void disposeCache(SolverScope<Solution_> solverScope) {
        this.cachedValueList = null;
    }

    @Override
    public GenuineVariableDescriptor<Solution_> getVariableDescriptor() {
        return this.childValueSelector.getVariableDescriptor();
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public long getSize(Object entity) {
        return this.getSize();
    }

    public long getSize() {
        return this.cachedValueList.size();
    }

    @Override
    public Iterator<Object> endingIterator(Object entity) {
        return this.endingIterator();
    }

    public Iterator<Object> endingIterator() {
        return this.cachedValueList.iterator();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AbstractCachingValueSelector that = (AbstractCachingValueSelector)other;
        return Objects.equals(this.childValueSelector, that.childValueSelector) && this.cacheType == that.cacheType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.childValueSelector, this.cacheType});
    }
}

