/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.list;

import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import ai.timefold.solver.core.impl.heuristic.selector.list.DestinationSelector;
import ai.timefold.solver.core.impl.heuristic.selector.list.SubList;
import ai.timefold.solver.core.impl.heuristic.selector.list.SubListSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.SubListChangeMove;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.SubListUnassignMove;
import ai.timefold.solver.core.preview.api.domain.metamodel.ElementPosition;
import ai.timefold.solver.core.preview.api.domain.metamodel.PositionInList;
import java.util.Iterator;
import java.util.Random;

class RandomSubListChangeMoveIterator<Solution_>
extends UpcomingSelectionIterator<Move<Solution_>> {
    private final Iterator<SubList> subListIterator;
    private final Iterator<ElementPosition> destinationIterator;
    private final ListVariableDescriptor<Solution_> listVariableDescriptor;
    private final Random workingRandom;
    private final boolean selectReversingMoveToo;

    RandomSubListChangeMoveIterator(SubListSelector<Solution_> subListSelector, DestinationSelector<Solution_> destinationSelector, Random workingRandom, boolean selectReversingMoveToo) {
        this.subListIterator = subListSelector.iterator();
        this.destinationIterator = destinationSelector.iterator();
        this.listVariableDescriptor = subListSelector.getVariableDescriptor();
        this.workingRandom = workingRandom;
        this.selectReversingMoveToo = selectReversingMoveToo;
    }

    @Override
    protected Move<Solution_> createUpcomingSelection() {
        if (!this.subListIterator.hasNext() || !this.destinationIterator.hasNext()) {
            return (Move)this.noUpcomingSelection();
        }
        SubList subList = this.subListIterator.next();
        ElementPosition destination = RandomSubListChangeMoveIterator.findUnpinnedDestination(this.destinationIterator, this.listVariableDescriptor);
        if (destination == null) {
            return (Move)this.noUpcomingSelection();
        }
        if (destination instanceof PositionInList) {
            PositionInList destinationElement = (PositionInList)destination;
            boolean reversing = this.selectReversingMoveToo && this.workingRandom.nextBoolean();
            return new SubListChangeMove<Solution_>(this.listVariableDescriptor, subList, destinationElement.entity(), destinationElement.index(), reversing);
        }
        return new SubListUnassignMove<Solution_>(this.listVariableDescriptor, subList);
    }
}

