/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.chained;

import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import ai.timefold.solver.core.impl.heuristic.move.AbstractMove;
import ai.timefold.solver.core.impl.heuristic.selector.value.chained.SubChain;
import ai.timefold.solver.core.impl.score.director.VariableDescriptorAwareScoreDirector;
import ai.timefold.solver.core.impl.util.CollectionUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;

public class SubChainSwapMove<Solution_>
extends AbstractMove<Solution_> {
    protected final GenuineVariableDescriptor<Solution_> variableDescriptor;
    protected final SubChain leftSubChain;
    protected final Object leftTrailingLastEntity;
    protected final SubChain rightSubChain;
    protected final Object rightTrailingLastEntity;

    public SubChainSwapMove(GenuineVariableDescriptor<Solution_> variableDescriptor, SingletonInverseVariableSupply inverseVariableSupply, SubChain leftSubChain, SubChain rightSubChain) {
        this.variableDescriptor = variableDescriptor;
        this.leftSubChain = leftSubChain;
        this.leftTrailingLastEntity = inverseVariableSupply.getInverseSingleton(leftSubChain.getLastEntity());
        this.rightSubChain = rightSubChain;
        this.rightTrailingLastEntity = inverseVariableSupply.getInverseSingleton(rightSubChain.getLastEntity());
    }

    public SubChainSwapMove(GenuineVariableDescriptor<Solution_> variableDescriptor, SubChain leftSubChain, Object leftTrailingLastEntity, SubChain rightSubChain, Object rightTrailingLastEntity) {
        this.variableDescriptor = variableDescriptor;
        this.leftSubChain = leftSubChain;
        this.rightSubChain = rightSubChain;
        this.leftTrailingLastEntity = leftTrailingLastEntity;
        this.rightTrailingLastEntity = rightTrailingLastEntity;
    }

    public String getVariableName() {
        return this.variableDescriptor.getVariableName();
    }

    public SubChain getLeftSubChain() {
        return this.leftSubChain;
    }

    public SubChain getRightSubChain() {
        return this.rightSubChain;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        return !SubChainSwapMove.containsAnyOf(this.rightSubChain, this.leftSubChain);
    }

    static boolean containsAnyOf(SubChain rightSubChain, SubChain leftSubChain) {
        int leftSubChainSize = leftSubChain.getSize();
        if (leftSubChainSize == 0) {
            return false;
        }
        if (leftSubChainSize == 1) {
            return rightSubChain.getEntityList().contains(leftSubChain.getFirstEntity());
        }
        HashSet<Object> rightSubChainEntityFastLookupSet = new HashSet<Object>(rightSubChain.getEntityList());
        for (Object leftEntity : leftSubChain.getEntityList()) {
            if (!rightSubChainEntityFastLookupSet.contains(leftEntity)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        Object leftFirstEntity = this.leftSubChain.getFirstEntity();
        Object leftFirstValue = this.variableDescriptor.getValue(leftFirstEntity);
        Object leftLastEntity = this.leftSubChain.getLastEntity();
        Object rightFirstEntity = this.rightSubChain.getFirstEntity();
        Object rightFirstValue = this.variableDescriptor.getValue(rightFirstEntity);
        Object rightLastEntity = this.rightSubChain.getLastEntity();
        VariableDescriptorAwareScoreDirector castScoreDirector = (VariableDescriptorAwareScoreDirector)scoreDirector;
        if (leftLastEntity != rightFirstValue) {
            castScoreDirector.changeVariableFacade(this.variableDescriptor, leftFirstEntity, rightFirstValue);
        }
        if (rightLastEntity != leftFirstValue) {
            castScoreDirector.changeVariableFacade(this.variableDescriptor, rightFirstEntity, leftFirstValue);
        }
        if (this.leftTrailingLastEntity != null) {
            if (this.leftTrailingLastEntity != rightFirstEntity) {
                castScoreDirector.changeVariableFacade(this.variableDescriptor, this.leftTrailingLastEntity, rightLastEntity);
            } else {
                castScoreDirector.changeVariableFacade(this.variableDescriptor, leftFirstEntity, rightLastEntity);
            }
        }
        if (this.rightTrailingLastEntity != null) {
            if (this.rightTrailingLastEntity != leftFirstEntity) {
                castScoreDirector.changeVariableFacade(this.variableDescriptor, this.rightTrailingLastEntity, leftLastEntity);
            } else {
                castScoreDirector.changeVariableFacade(this.variableDescriptor, rightFirstEntity, leftLastEntity);
            }
        }
    }

    @Override
    public SubChainSwapMove<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        return new SubChainSwapMove<Solution_>(this.variableDescriptor, this.leftSubChain.rebase(destinationScoreDirector), destinationScoreDirector.lookUpWorkingObject(this.leftTrailingLastEntity), this.rightSubChain.rebase(destinationScoreDirector), destinationScoreDirector.lookUpWorkingObject(this.rightTrailingLastEntity));
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    @Override
    public Collection<?> getPlanningEntities() {
        return CollectionUtils.concat(this.leftSubChain.getEntityList(), this.rightSubChain.getEntityList());
    }

    @Override
    public Collection<?> getPlanningValues() {
        return Arrays.asList(this.variableDescriptor.getValue(this.leftSubChain.getFirstEntity()), this.variableDescriptor.getValue(this.rightSubChain.getFirstEntity()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubChainSwapMove other = (SubChainSwapMove)o;
        return Objects.equals(this.variableDescriptor, other.variableDescriptor) && Objects.equals(this.leftSubChain, other.leftSubChain) && Objects.equals(this.rightSubChain, other.rightSubChain);
    }

    public int hashCode() {
        return Objects.hash(this.variableDescriptor, this.leftSubChain, this.rightSubChain);
    }

    public String toString() {
        Object oldLeftValue = this.variableDescriptor.getValue(this.leftSubChain.getFirstEntity());
        Object oldRightValue = this.variableDescriptor.getValue(this.rightSubChain.getFirstEntity());
        return this.leftSubChain.toDottedString() + " {" + String.valueOf(oldLeftValue) + "} <-> " + this.rightSubChain.toDottedString() + " {" + String.valueOf(oldRightValue) + "}";
    }
}

