/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.chained;

import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.variable.descriptor.BasicVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.SwapMove;
import ai.timefold.solver.core.impl.score.director.VariableDescriptorAwareScoreDirector;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ChainedSwapMove<Solution_>
extends SwapMove<Solution_> {
    protected final List<Object> oldLeftTrailingEntityList;
    protected final List<Object> oldRightTrailingEntityList;

    public ChainedSwapMove(List<GenuineVariableDescriptor<Solution_>> variableDescriptorList, List<SingletonInverseVariableSupply> inverseVariableSupplyList, Object leftEntity, Object rightEntity) {
        super(variableDescriptorList, leftEntity, rightEntity);
        this.oldLeftTrailingEntityList = new ArrayList<Object>(inverseVariableSupplyList.size());
        this.oldRightTrailingEntityList = new ArrayList<Object>(inverseVariableSupplyList.size());
        for (SingletonInverseVariableSupply inverseVariableSupply : inverseVariableSupplyList) {
            boolean hasSupply = inverseVariableSupply != null;
            this.oldLeftTrailingEntityList.add(hasSupply ? inverseVariableSupply.getInverseSingleton(leftEntity) : null);
            this.oldRightTrailingEntityList.add(hasSupply ? inverseVariableSupply.getInverseSingleton(rightEntity) : null);
        }
    }

    public ChainedSwapMove(List<GenuineVariableDescriptor<Solution_>> genuineVariableDescriptors, Object leftEntity, Object rightEntity, List<Object> oldLeftTrailingEntityList, List<Object> oldRightTrailingEntityList) {
        super(genuineVariableDescriptors, leftEntity, rightEntity);
        this.oldLeftTrailingEntityList = oldLeftTrailingEntityList;
        this.oldRightTrailingEntityList = oldRightTrailingEntityList;
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        for (int i = 0; i < this.variableDescriptorList.size(); ++i) {
            BasicVariableDescriptor basicVariableDescriptor;
            boolean isChained;
            Object oldRightValue;
            GenuineVariableDescriptor variableDescriptor = (GenuineVariableDescriptor)this.variableDescriptorList.get(i);
            Object oldLeftValue = variableDescriptor.getValue(this.leftEntity);
            if (Objects.equals(oldLeftValue, oldRightValue = variableDescriptor.getValue(this.rightEntity))) continue;
            VariableDescriptorAwareScoreDirector castScoreDirector = (VariableDescriptorAwareScoreDirector)scoreDirector;
            boolean bl = isChained = variableDescriptor instanceof BasicVariableDescriptor && (basicVariableDescriptor = (BasicVariableDescriptor)variableDescriptor).isChained();
            if (!isChained) {
                castScoreDirector.changeVariableFacade(variableDescriptor, this.leftEntity, oldRightValue);
                castScoreDirector.changeVariableFacade(variableDescriptor, this.rightEntity, oldLeftValue);
                continue;
            }
            Object oldLeftTrailingEntity = this.oldLeftTrailingEntityList.get(i);
            Object oldRightTrailingEntity = this.oldRightTrailingEntityList.get(i);
            if (oldRightValue == this.leftEntity) {
                castScoreDirector.changeVariableFacade(variableDescriptor, this.rightEntity, oldLeftValue);
                castScoreDirector.changeVariableFacade(variableDescriptor, this.leftEntity, this.rightEntity);
                if (oldRightTrailingEntity == null) continue;
                castScoreDirector.changeVariableFacade(variableDescriptor, oldRightTrailingEntity, this.leftEntity);
                continue;
            }
            if (oldLeftValue == this.rightEntity) {
                castScoreDirector.changeVariableFacade(variableDescriptor, this.leftEntity, oldRightValue);
                castScoreDirector.changeVariableFacade(variableDescriptor, this.rightEntity, this.leftEntity);
                if (oldLeftTrailingEntity == null) continue;
                castScoreDirector.changeVariableFacade(variableDescriptor, oldLeftTrailingEntity, this.rightEntity);
                continue;
            }
            castScoreDirector.changeVariableFacade(variableDescriptor, this.leftEntity, oldRightValue);
            castScoreDirector.changeVariableFacade(variableDescriptor, this.rightEntity, oldLeftValue);
            if (oldRightTrailingEntity != null) {
                castScoreDirector.changeVariableFacade(variableDescriptor, oldRightTrailingEntity, this.leftEntity);
            }
            if (oldLeftTrailingEntity == null) continue;
            castScoreDirector.changeVariableFacade(variableDescriptor, oldLeftTrailingEntity, this.rightEntity);
        }
    }

    @Override
    public ChainedSwapMove<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        return new ChainedSwapMove<Solution_>(this.variableDescriptorList, destinationScoreDirector.lookUpWorkingObject(this.leftEntity), destinationScoreDirector.lookUpWorkingObject(this.rightEntity), ChainedSwapMove.rebaseList(this.oldLeftTrailingEntityList, destinationScoreDirector), ChainedSwapMove.rebaseList(this.oldRightTrailingEntityList, destinationScoreDirector));
    }
}

