/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic;

import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.move.NoChangeMove;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.RuinRecreateConstructionHeuristicPhaseBuilder;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.RuinRecreateMove;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;

final class RuinRecreateMoveIterator<Solution_>
extends UpcomingSelectionIterator<Move<Solution_>> {
    private final EntitySelector<Solution_> entitySelector;
    private final GenuineVariableDescriptor<Solution_> variableDescriptor;
    private final RuinRecreateConstructionHeuristicPhaseBuilder<Solution_> constructionHeuristicPhaseBuilder;
    private final SolverScope<Solution_> solverScope;
    private final int minimumRuinedCount;
    private final int maximumRuinedCount;
    private final Random workingRandom;

    public RuinRecreateMoveIterator(EntitySelector<Solution_> entitySelector, GenuineVariableDescriptor<Solution_> variableDescriptor, RuinRecreateConstructionHeuristicPhaseBuilder<Solution_> constructionHeuristicPhaseBuilder, SolverScope<Solution_> solverScope, int minimumRuinedCount, int maximumRuinedCount, Random workingRandom) {
        this.entitySelector = entitySelector;
        this.variableDescriptor = variableDescriptor;
        this.constructionHeuristicPhaseBuilder = constructionHeuristicPhaseBuilder;
        this.solverScope = solverScope;
        this.minimumRuinedCount = minimumRuinedCount;
        this.maximumRuinedCount = maximumRuinedCount;
        this.workingRandom = workingRandom;
    }

    @Override
    protected Move<Solution_> createUpcomingSelection() {
        Iterator entityIterator = this.entitySelector.iterator();
        int ruinedCount = this.workingRandom.nextInt(this.minimumRuinedCount, this.maximumRuinedCount + 1);
        ArrayList<Object> selectedEntityList = new ArrayList<Object>(ruinedCount);
        Set<Object> affectedValueSet = CollectionUtils.newLinkedHashSet(ruinedCount);
        Set selectedEntitySet = Collections.newSetFromMap(CollectionUtils.newIdentityHashMap(ruinedCount));
        block0: for (int i = 0; i < ruinedCount; ++i) {
            int remainingAttempts = ruinedCount;
            do {
                if (!entityIterator.hasNext()) {
                    return NoChangeMove.getInstance();
                }
                Object selectedEntity = entityIterator.next();
                if (!selectedEntitySet.add(selectedEntity)) continue;
                selectedEntityList.add(selectedEntity);
                Object affectedValue = this.variableDescriptor.getValue(selectedEntity);
                if (affectedValue == null) continue block0;
                affectedValueSet.add(affectedValue);
                continue block0;
            } while (--remainingAttempts != 0);
            return NoChangeMove.getInstance();
        }
        return new RuinRecreateMove<Solution_>(this.variableDescriptor, this.constructionHeuristicPhaseBuilder, this.solverScope, selectedEntityList, affectedValueSet);
    }
}

