/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.listener.support.violation;

import ai.timefold.solver.core.impl.domain.variable.ListElementsChangeEvent;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.listener.SourcedListVariableListener;
import ai.timefold.solver.core.impl.domain.variable.listener.support.violation.VariableId;
import ai.timefold.solver.core.impl.domain.variable.supply.Demand;
import ai.timefold.solver.core.impl.domain.variable.supply.Supply;
import ai.timefold.solver.core.impl.domain.variable.supply.SupplyManager;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ListVariableTracker<Solution_>
implements SourcedListVariableListener<Solution_, Object, Object>,
Supply {
    private final ListVariableDescriptor<Solution_> variableDescriptor;
    private final List<Object> beforeVariableChangedEntityList;
    private final List<Object> afterVariableChangedEntityList;

    public ListVariableTracker(ListVariableDescriptor<Solution_> variableDescriptor) {
        this.variableDescriptor = variableDescriptor;
        this.beforeVariableChangedEntityList = new ArrayList<Object>();
        this.afterVariableChangedEntityList = new ArrayList<Object>();
    }

    @Override
    public VariableDescriptor<Solution_> getSourceVariableDescriptor() {
        return this.variableDescriptor;
    }

    @Override
    public void resetWorkingSolution(InnerScoreDirector<Solution_, ?> scoreDirector) {
        this.beforeVariableChangedEntityList.clear();
        this.afterVariableChangedEntityList.clear();
    }

    @Override
    public void beforeChange(InnerScoreDirector<Solution_, ?> scoreDirector, ListElementsChangeEvent<Object> event) {
        this.beforeVariableChangedEntityList.add(event.entity());
    }

    @Override
    public void afterChange(InnerScoreDirector<Solution_, ?> scoreDirector, ListElementsChangeEvent<Object> event) {
        this.afterVariableChangedEntityList.add(event.entity());
    }

    public List<String> getEntitiesMissingBeforeAfterEvents(List<VariableId<Solution_>> changedVariables) {
        ArrayList<String> out = new ArrayList<String>();
        for (VariableId<Solution_> changedVariable : changedVariables) {
            if (!this.variableDescriptor.equals(changedVariable.variableDescriptor())) continue;
            Object entity = changedVariable.entity();
            if (!this.beforeVariableChangedEntityList.contains(entity)) {
                out.add("Entity (" + String.valueOf(entity) + ") is missing a beforeListVariableChanged call for list variable (" + this.variableDescriptor.getVariableName() + ").");
            }
            if (this.afterVariableChangedEntityList.contains(entity)) continue;
            out.add("Entity (" + String.valueOf(entity) + ") is missing a afterListVariableChanged call for list variable (" + this.variableDescriptor.getVariableName() + ").");
        }
        this.beforeVariableChangedEntityList.clear();
        this.afterVariableChangedEntityList.clear();
        return out;
    }

    public TrackerDemand demand() {
        return new TrackerDemand();
    }

    @Override
    public void afterListElementUnassigned(InnerScoreDirector<Solution_, ?> scoreDirector, Object unassignedElement) {
    }

    public class TrackerDemand
    implements Demand<ListVariableTracker<Solution_>> {
        @Override
        public ListVariableTracker<Solution_> createExternalizedSupply(SupplyManager supplyManager) {
            return ListVariableTracker.this;
        }
    }
}

