/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.inverserelation;

import ai.timefold.solver.core.impl.domain.variable.BasicVariableChangeEvent;
import ai.timefold.solver.core.impl.domain.variable.InnerBasicVariableListener;
import ai.timefold.solver.core.impl.domain.variable.InnerVariableListener;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.CollectionInverseVariableSupply;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.InverseRelationShadowVariableDescriptor;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import java.util.Collection;

public class CollectionInverseVariableListener<Solution_>
implements InnerBasicVariableListener<Solution_, Object>,
CollectionInverseVariableSupply {
    protected final InverseRelationShadowVariableDescriptor<Solution_> shadowVariableDescriptor;
    protected final VariableDescriptor<Solution_> sourceVariableDescriptor;

    public CollectionInverseVariableListener(InverseRelationShadowVariableDescriptor<Solution_> shadowVariableDescriptor, VariableDescriptor<Solution_> sourceVariableDescriptor) {
        this.shadowVariableDescriptor = shadowVariableDescriptor;
        this.sourceVariableDescriptor = sourceVariableDescriptor;
    }

    @Override
    public void resetWorkingSolution(InnerScoreDirector<Solution_, ?> scoreDirector) {
        InnerVariableListener.forEachEntity(scoreDirector, this.shadowVariableDescriptor.getEntityDescriptor().getEntityClass(), value -> this.getInverseCollection(value).clear());
        InnerVariableListener.forEachEntity(scoreDirector, this.sourceVariableDescriptor.getEntityDescriptor().getEntityClass(), entity -> this.insert(scoreDirector, entity));
    }

    @Override
    public void beforeChange(InnerScoreDirector<Solution_, ?> scoreDirector, BasicVariableChangeEvent<Object> event) {
        this.retract(scoreDirector, event.entity());
    }

    @Override
    public void afterChange(InnerScoreDirector<Solution_, ?> scoreDirector, BasicVariableChangeEvent<Object> event) {
        this.insert(scoreDirector, event.entity());
    }

    protected void insert(InnerScoreDirector<Solution_, ?> scoreDirector, Object entity) {
        Object shadowEntity = this.sourceVariableDescriptor.getValue(entity);
        if (shadowEntity != null) {
            Collection shadowCollection = (Collection)this.shadowVariableDescriptor.getValue(shadowEntity);
            if (scoreDirector.expectShadowVariablesInCorrectState() && shadowCollection == null) {
                throw new IllegalStateException("The entity (%s) has a variable (%s) with value (%s) which has a sourceVariableName variable (%s) with a value (%s) which is null.\nVerify the consistency of your input problem for that bi-directional relationship.\nNon-singleton inverse variable can never be null, at the very least it should be an empty %s.".formatted(entity, this.sourceVariableDescriptor.getVariableName(), shadowEntity, this.shadowVariableDescriptor.getVariableName(), shadowCollection, Collection.class.getSimpleName()));
            }
            scoreDirector.beforeVariableChanged(this.shadowVariableDescriptor, shadowEntity);
            boolean added = shadowCollection.add(entity);
            if (scoreDirector.expectShadowVariablesInCorrectState() && !added) {
                throw new IllegalStateException("The entity (%s) has a variable (%s) with value (%s) which has a sourceVariableName variable (%s) with a value (%s) which already contained the entity (%s).\nVerify the consistency of your input problem for that bi-directional relationship.".formatted(entity, this.sourceVariableDescriptor.getVariableName(), shadowEntity, this.shadowVariableDescriptor.getVariableName(), shadowCollection, entity));
            }
            scoreDirector.afterVariableChanged(this.shadowVariableDescriptor, shadowEntity);
        }
    }

    protected void retract(InnerScoreDirector<Solution_, ?> scoreDirector, Object entity) {
        Object shadowEntity = this.sourceVariableDescriptor.getValue(entity);
        if (shadowEntity != null) {
            Collection shadowCollection = (Collection)this.shadowVariableDescriptor.getValue(shadowEntity);
            if (scoreDirector.expectShadowVariablesInCorrectState() && shadowCollection == null) {
                throw new IllegalStateException("The entity (%s) has a variable (%s) with value (%s) which has a sourceVariableName variable (%s) with a value (%s) which is null.\nVerify the consistency of your input problem for that bi-directional relationship.\nNon-singleton inverse variable can never be null, at the very least it should be an empty %s.".formatted(entity, this.sourceVariableDescriptor.getVariableName(), shadowEntity, this.shadowVariableDescriptor.getVariableName(), shadowCollection, Collection.class.getSimpleName()));
            }
            scoreDirector.beforeVariableChanged(this.shadowVariableDescriptor, shadowEntity);
            boolean removed = shadowCollection.remove(entity);
            if (scoreDirector.expectShadowVariablesInCorrectState() && !removed) {
                throw new IllegalStateException("The entity (%s) has a variable (%s) with value (%s) which has a sourceVariableName variable (%s) with a value (%s) which did not contain the entity (%s)\nVerify the consistency of your input problem for that bi-directional relationship.".formatted(entity, this.sourceVariableDescriptor.getVariableName(), shadowEntity, this.shadowVariableDescriptor.getVariableName(), shadowCollection, entity));
            }
            scoreDirector.afterVariableChanged(this.shadowVariableDescriptor, shadowEntity);
        }
    }

    @Override
    public Collection<?> getInverseCollection(Object planningValue) {
        return (Collection)this.shadowVariableDescriptor.getValue(planningValue);
    }
}

