/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.declarative;

import ai.timefold.solver.core.impl.domain.variable.declarative.VariableUpdaterInfo;
import ai.timefold.solver.core.impl.util.MutableReference;
import ai.timefold.solver.core.preview.api.domain.metamodel.VariableMetaModel;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class EntityVariableUpdaterLookup<Solution_> {
    private final Map<Object, Lookup<Solution_>> variableToEntityLookup = new LinkedHashMap<Object, Lookup<Solution_>>();
    private final Supplier<Lookup<Solution_>> entityLookupSupplier;
    private int nextId = 0;

    private EntityVariableUpdaterLookup(Supplier<Lookup<Solution_>> entityLookupSupplier) {
        this.entityLookupSupplier = entityLookupSupplier;
    }

    public static <Solution_> EntityVariableUpdaterLookup<Solution_> entityIndependentLookup() {
        Supplier<Lookup<Solution_>> lookupSupplier = () -> {
            MutableReference<Object> sharedValue = new MutableReference<Object>(null);
            return new Lookup((ignored1, ignored2) -> (List)sharedValue.getValue(), (ignored1, ignored2, valueSupplier) -> {
                if (sharedValue.getValue() == null) {
                    sharedValue.setValue(((List)valueSupplier.get()));
                }
            });
        };
        return new EntityVariableUpdaterLookup<Solution_>(lookupSupplier);
    }

    public static <Solution_> EntityVariableUpdaterLookup<Solution_> entityDependentLookup() {
        Supplier<Lookup<Solution_>> lookupSupplier = () -> {
            IdentityHashMap valueMap = new IdentityHashMap();
            return new Lookup((entity, ignored) -> (List)valueMap.get(entity), (entity, ignored, valueSupplier) -> valueMap.computeIfAbsent(entity, arg_0 -> EntityVariableUpdaterLookup.lambda$entityDependentLookup$4((Supplier)valueSupplier, arg_0)));
        };
        return new EntityVariableUpdaterLookup<Solution_>(lookupSupplier);
    }

    public static <Solution_> EntityVariableUpdaterLookup<Solution_> groupedEntityDependentLookup(Function<VariableMetaModel<Solution_, ?, ?>, @Nullable Function<Object, @Nullable Object>> variableToAlignmentKeyMapper) {
        Supplier<Lookup<Solution_>> lookupSupplier = () -> {
            IdentityHashMap valueMap = new IdentityHashMap();
            LinkedHashMap alignmentKeyToUpdaters = new LinkedHashMap();
            LookupGetter valueReader = (entity, variableMetaModel) -> {
                Object alignmentKey;
                Function alignmentKeyMapper = (Function)variableToAlignmentKeyMapper.apply(variableMetaModel);
                if (alignmentKeyMapper != null && (alignmentKey = alignmentKeyMapper.apply(entity)) != null) {
                    return (List)alignmentKeyToUpdaters.get(alignmentKey);
                }
                return (List)valueMap.get(entity);
            };
            LookupSetter valueSetter = (entity, variableMetaModel, valueSupplier) -> {
                Object alignmentKey;
                Function alignmentKeyMapper = (Function)variableToAlignmentKeyMapper.apply(variableMetaModel);
                if (alignmentKeyMapper != null && (alignmentKey = alignmentKeyMapper.apply(entity)) != null) {
                    alignmentKeyToUpdaters.computeIfAbsent(alignmentKey, arg_0 -> EntityVariableUpdaterLookup.lambda$groupedEntityDependentLookup$8((Supplier)valueSupplier, arg_0));
                    return;
                }
                valueMap.computeIfAbsent(entity, arg_0 -> EntityVariableUpdaterLookup.lambda$groupedEntityDependentLookup$9((Supplier)valueSupplier, arg_0));
            };
            return new Lookup(valueReader, valueSetter);
        };
        return new EntityVariableUpdaterLookup<Solution_>(lookupSupplier);
    }

    public List<VariableUpdaterInfo<Solution_>> computeUpdatersForVariableOnEntity(VariableMetaModel<Solution_, ?, ?> variableMetaModel, Object entity, Supplier<List<VariableUpdaterInfo<Solution_>>> updatersSupplier) {
        Lookup entityLookup = this.variableToEntityLookup.computeIfAbsent(variableMetaModel, ignored -> this.entityLookupSupplier.get());
        entityLookup.setUpdaters(entity, variableMetaModel, updatersSupplier);
        return entityLookup.getUpdaters(entity, variableMetaModel);
    }

    public int getNextId() {
        return this.nextId++;
    }

    private static /* synthetic */ List lambda$groupedEntityDependentLookup$9(Supplier valueSupplier, Object ignored) {
        return (List)valueSupplier.get();
    }

    private static /* synthetic */ List lambda$groupedEntityDependentLookup$8(Supplier valueSupplier, Object ignored) {
        return (List)valueSupplier.get();
    }

    private static /* synthetic */ List lambda$entityDependentLookup$4(Supplier valueSupplier, Object ignored2) {
        return (List)valueSupplier.get();
    }

    private record Lookup<Solution_>(LookupGetter<Solution_> getter, LookupSetter<Solution_> setter) {
        List<VariableUpdaterInfo<Solution_>> getUpdaters(Object entity, VariableMetaModel<Solution_, ?, ?> variableMetaModel) {
            return this.getter.get(entity, variableMetaModel);
        }

        void setUpdaters(Object entity, VariableMetaModel<Solution_, ?, ?> variableMetaModel, Supplier<List<VariableUpdaterInfo<Solution_>>> updatersSupplier) {
            this.setter.putIfMissing(entity, variableMetaModel, updatersSupplier);
        }
    }

    private static interface LookupGetter<Solution_> {
        public List<VariableUpdaterInfo<Solution_>> get(Object var1, VariableMetaModel<Solution_, ?, ?> var2);
    }

    private static interface LookupSetter<Solution_> {
        public void putIfMissing(Object var1, VariableMetaModel<Solution_, ?, ?> var2, Supplier<List<VariableUpdaterInfo<Solution_>>> var3);
    }
}

