/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.declarative;

import ai.timefold.solver.core.impl.domain.variable.declarative.GraphNode;
import ai.timefold.solver.core.impl.domain.variable.declarative.TopologicalOrderGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableReferenceGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableReferenceGraphBuilder;
import ai.timefold.solver.core.impl.util.DynamicLinearProbeNonNegativeIntCounter;
import ai.timefold.solver.core.preview.api.domain.metamodel.VariableMetaModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AbstractVariableReferenceGraph<Solution_, ChangeSet_>
implements VariableReferenceGraph {
    protected final List<GraphNode<Solution_>> nodeList;
    protected final Map<VariableMetaModel<?, ?, ?>, Map<Object, GraphNode<Solution_>>> variableReferenceToContainingNodeMap;
    protected final Map<VariableMetaModel<?, ?, ?>, List<BiConsumer<AbstractVariableReferenceGraph<Solution_, ?>, Object>>> variableReferenceToBeforeProcessor;
    protected final Map<VariableMetaModel<?, ?, ?>, List<BiConsumer<AbstractVariableReferenceGraph<Solution_, ?>, Object>>> variableReferenceToAfterProcessor;
    protected final DynamicLinearProbeNonNegativeIntCounter[] edgeCount;
    protected final ChangeSet_ changeSet;
    protected final TopologicalOrderGraph graph;

    AbstractVariableReferenceGraph(VariableReferenceGraphBuilder<Solution_> outerGraph, IntFunction<TopologicalOrderGraph> graphCreator) {
        this.nodeList = List.copyOf(outerGraph.nodeList);
        int instanceCount = this.nodeList.size();
        this.variableReferenceToContainingNodeMap = AbstractVariableReferenceGraph.mapOfMapsDeepCopyOf(outerGraph.variableReferenceToContainingNodeMap);
        this.variableReferenceToBeforeProcessor = AbstractVariableReferenceGraph.mapOfListsDeepCopyOf(outerGraph.variableReferenceToBeforeProcessor);
        this.variableReferenceToAfterProcessor = AbstractVariableReferenceGraph.mapOfListsDeepCopyOf(outerGraph.variableReferenceToAfterProcessor);
        this.edgeCount = new DynamicLinearProbeNonNegativeIntCounter[instanceCount];
        for (int i = 0; i < instanceCount; ++i) {
            this.edgeCount[i] = new DynamicLinearProbeNonNegativeIntCounter();
        }
        this.graph = graphCreator.apply(instanceCount);
        this.graph.withNodeData(this.nodeList);
        Set visited = Collections.newSetFromMap(new IdentityHashMap());
        this.changeSet = this.createChangeSet(instanceCount);
        for (GraphNode<Solution_> graphNode : this.nodeList) {
            Object entity = graphNode.entity();
            if (!visited.add(entity)) continue;
            for (VariableMetaModel<?, ?, ?> variableId : outerGraph.variableReferenceToAfterProcessor.keySet()) {
                this.afterVariableChanged(variableId, entity);
            }
        }
        for (Map.Entry entry : outerGraph.fixedEdges.entrySet()) {
            for (GraphNode toEdge : (List)entry.getValue()) {
                this.addEdge((GraphNode)entry.getKey(), toEdge);
            }
        }
    }

    protected abstract ChangeSet_ createChangeSet(int var1);

    public @Nullable GraphNode<Solution_> lookupOrNull(VariableMetaModel<?, ?, ?> variableId, Object entity) {
        Map<Object, GraphNode<Solution_>> map = this.variableReferenceToContainingNodeMap.get(variableId);
        if (map == null) {
            return null;
        }
        return map.get(entity);
    }

    public void addEdge(@NonNull GraphNode<Solution_> from, @NonNull GraphNode<Solution_> to) {
        int toNodeId;
        int fromNodeId = from.graphNodeId();
        if (fromNodeId == (toNodeId = to.graphNodeId())) {
            return;
        }
        int count = this.edgeCount[fromNodeId].getCount(toNodeId);
        if (count == 0) {
            this.graph.addEdge(fromNodeId, toNodeId);
        }
        this.edgeCount[fromNodeId].increment(toNodeId);
        this.markChanged(to);
    }

    public void removeEdge(@NonNull GraphNode<Solution_> from, @NonNull GraphNode<Solution_> to) {
        int toNodeId;
        int fromNodeId = from.graphNodeId();
        if (fromNodeId == (toNodeId = to.graphNodeId())) {
            return;
        }
        int count = this.edgeCount[fromNodeId].getCount(toNodeId);
        if (count == 1) {
            this.graph.removeEdge(fromNodeId, toNodeId);
        }
        this.edgeCount[fromNodeId].decrement(toNodeId);
        this.markChanged(to);
    }

    abstract void markChanged(GraphNode<Solution_> var1);

    @Override
    public void beforeVariableChanged(VariableMetaModel<?, ?, ?> variableReference, Object entity) {
        if (variableReference.entity().type().isInstance(entity)) {
            this.processEntity(this.variableReferenceToBeforeProcessor.getOrDefault(variableReference, Collections.emptyList()), entity);
        }
    }

    private void processEntity(List<BiConsumer<AbstractVariableReferenceGraph<Solution_, ?>, Object>> processorList, Object entity) {
        int processorCount = processorList.size();
        for (int i = 0; i < processorCount; ++i) {
            processorList.get(i).accept(this, entity);
        }
    }

    @Override
    public void afterVariableChanged(VariableMetaModel<?, ?, ?> variableReference, Object entity) {
        if (variableReference.entity().type().isInstance(entity)) {
            GraphNode<Solution_> node = this.lookupOrNull(variableReference, entity);
            if (node != null) {
                this.markChanged(node);
            }
            this.processEntity(this.variableReferenceToAfterProcessor.getOrDefault(variableReference, Collections.emptyList()), entity);
        }
    }

    public String toString() {
        LinkedHashMap edgeList = new LinkedHashMap();
        this.graph.forEachEdge((from, to) -> edgeList.computeIfAbsent(this.nodeList.get(from), k -> new ArrayList()).add(this.nodeList.get(to)));
        return edgeList.entrySet().stream().map(e -> String.valueOf(e.getKey()) + "->" + String.valueOf(e.getValue())).collect(Collectors.joining("," + System.lineSeparator() + " ", "{" + System.lineSeparator() + "  ", "}"));
    }

    static <K1, K2, V> Map<K1, Map<K2, V>> mapOfMapsDeepCopyOf(Map<K1, Map<K2, V>> map) {
        Map.Entry[] entryArray = (Map.Entry[])map.entrySet().stream().map(e -> Map.entry(e.getKey(), Map.copyOf((Map)e.getValue()))).toArray(Map.Entry[]::new);
        return Map.ofEntries(entryArray);
    }

    static <K1, V> Map<K1, List<V>> mapOfListsDeepCopyOf(Map<K1, List<V>> map) {
        Map.Entry[] entryArray = (Map.Entry[])map.entrySet().stream().map(e -> Map.entry(e.getKey(), List.copyOf((Collection)e.getValue()))).toArray(Map.Entry[]::new);
        return Map.ofEntries(entryArray);
    }
}

