/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable;

import ai.timefold.solver.core.impl.domain.variable.index.IndexShadowVariableDescriptor;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import java.util.Objects;

final class ExternalizedIndexVariableProcessor<Solution_> {
    private final IndexShadowVariableDescriptor<Solution_> shadowVariableDescriptor;

    public ExternalizedIndexVariableProcessor(IndexShadowVariableDescriptor<Solution_> shadowVariableDescriptor) {
        this.shadowVariableDescriptor = shadowVariableDescriptor;
    }

    public void addElement(InnerScoreDirector<Solution_, ?> scoreDirector, Object element, Integer index) {
        this.updateIndex(scoreDirector, element, index);
    }

    public void removeElement(InnerScoreDirector<Solution_, ?> scoreDirector, Object element) {
        this.updateIndex(scoreDirector, element, null);
    }

    public void unassignElement(InnerScoreDirector<Solution_, ?> scoreDirector, Object element) {
        this.removeElement(scoreDirector, element);
    }

    public void changeElement(InnerScoreDirector<Solution_, ?> scoreDirector, Object element, Integer index) {
        this.updateIndex(scoreDirector, element, index);
    }

    private void updateIndex(InnerScoreDirector<Solution_, ?> scoreDirector, Object element, Integer index) {
        Integer oldIndex = this.getIndex(element);
        if (!Objects.equals(oldIndex, index)) {
            scoreDirector.beforeVariableChanged(this.shadowVariableDescriptor, element);
            this.shadowVariableDescriptor.setValue(element, index);
            scoreDirector.afterVariableChanged(this.shadowVariableDescriptor, element);
        }
    }

    public Integer getIndex(Object planningValue) {
        return this.shadowVariableDescriptor.getValue(planningValue);
    }
}

