/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.solution.cloner;

import ai.timefold.solver.core.impl.domain.common.accessor.FieldHandle;
import java.lang.reflect.Field;

final class FieldCloningUtils {
    static void copyBoolean(Field field, Object original, Object clone) {
        boolean originalValue = FieldCloningUtils.getBooleanFieldValue(original, field);
        FieldCloningUtils.setFieldValue(clone, field, originalValue);
    }

    private static boolean getBooleanFieldValue(Object bean, Field field) {
        try {
            return field.getBoolean(bean);
        }
        catch (IllegalAccessException e) {
            throw FieldCloningUtils.createExceptionOnRead(bean, field, e);
        }
    }

    private static void setFieldValue(Object bean, Field field, boolean value) {
        try {
            field.setBoolean(bean, value);
        }
        catch (IllegalAccessException e) {
            throw FieldCloningUtils.createExceptionOnWrite(bean, field, value, e);
        }
    }

    static void copyByte(Field field, Object original, Object clone) {
        byte originalValue = FieldCloningUtils.getByteFieldValue(original, field);
        FieldCloningUtils.setFieldValue(clone, field, originalValue);
    }

    private static byte getByteFieldValue(Object bean, Field field) {
        try {
            return field.getByte(bean);
        }
        catch (IllegalAccessException e) {
            throw FieldCloningUtils.createExceptionOnRead(bean, field, e);
        }
    }

    private static void setFieldValue(Object bean, Field field, byte value) {
        try {
            field.setByte(bean, value);
        }
        catch (IllegalAccessException e) {
            throw FieldCloningUtils.createExceptionOnWrite(bean, field, value, e);
        }
    }

    static void copyChar(Field field, Object original, Object clone) {
        char originalValue = FieldCloningUtils.getCharFieldValue(original, field);
        FieldCloningUtils.setFieldValue(clone, field, originalValue);
    }

    private static char getCharFieldValue(Object bean, Field field) {
        try {
            return field.getChar(bean);
        }
        catch (IllegalAccessException e) {
            throw FieldCloningUtils.createExceptionOnRead(bean, field, e);
        }
    }

    private static void setFieldValue(Object bean, Field field, char value) {
        try {
            field.setChar(bean, value);
        }
        catch (IllegalAccessException e) {
            throw FieldCloningUtils.createExceptionOnWrite(bean, field, Character.valueOf(value), e);
        }
    }

    static void copyShort(Field field, Object original, Object clone) {
        short originalValue = FieldCloningUtils.getShortFieldValue(original, field);
        FieldCloningUtils.setFieldValue(clone, field, originalValue);
    }

    private static short getShortFieldValue(Object bean, Field field) {
        try {
            return field.getShort(bean);
        }
        catch (IllegalAccessException e) {
            throw FieldCloningUtils.createExceptionOnRead(bean, field, e);
        }
    }

    private static void setFieldValue(Object bean, Field field, short value) {
        try {
            field.setShort(bean, value);
        }
        catch (IllegalAccessException e) {
            throw FieldCloningUtils.createExceptionOnWrite(bean, field, value, e);
        }
    }

    static void copyInt(Field field, Object original, Object clone) {
        int originalValue = FieldCloningUtils.getIntFieldValue(original, field);
        FieldCloningUtils.setFieldValue(clone, field, originalValue);
    }

    private static int getIntFieldValue(Object bean, Field field) {
        try {
            return field.getInt(bean);
        }
        catch (IllegalAccessException e) {
            throw FieldCloningUtils.createExceptionOnRead(bean, field, e);
        }
    }

    private static void setFieldValue(Object bean, Field field, int value) {
        try {
            field.setInt(bean, value);
        }
        catch (IllegalAccessException e) {
            throw FieldCloningUtils.createExceptionOnWrite(bean, field, value, e);
        }
    }

    static void copyLong(Field field, Object original, Object clone) {
        long originalValue = FieldCloningUtils.getLongFieldValue(original, field);
        FieldCloningUtils.setFieldValue(clone, field, originalValue);
    }

    private static long getLongFieldValue(Object bean, Field field) {
        try {
            return field.getLong(bean);
        }
        catch (IllegalAccessException e) {
            throw FieldCloningUtils.createExceptionOnRead(bean, field, e);
        }
    }

    private static void setFieldValue(Object bean, Field field, long value) {
        try {
            field.setLong(bean, value);
        }
        catch (IllegalAccessException e) {
            throw FieldCloningUtils.createExceptionOnWrite(bean, field, value, e);
        }
    }

    static void copyFloat(Field field, Object original, Object clone) {
        float originalValue = FieldCloningUtils.getFloatFieldValue(original, field);
        FieldCloningUtils.setFieldValue(clone, field, originalValue);
    }

    private static float getFloatFieldValue(Object bean, Field field) {
        try {
            return field.getFloat(bean);
        }
        catch (IllegalAccessException e) {
            throw FieldCloningUtils.createExceptionOnRead(bean, field, e);
        }
    }

    private static void setFieldValue(Object bean, Field field, float value) {
        try {
            field.setFloat(bean, value);
        }
        catch (IllegalAccessException e) {
            throw FieldCloningUtils.createExceptionOnWrite(bean, field, Float.valueOf(value), e);
        }
    }

    static void copyDouble(Field field, Object original, Object clone) {
        double originalValue = FieldCloningUtils.getDoubleFieldValue(original, field);
        FieldCloningUtils.setFieldValue(clone, field, originalValue);
    }

    private static double getDoubleFieldValue(Object bean, Field field) {
        try {
            return field.getDouble(bean);
        }
        catch (IllegalAccessException e) {
            throw FieldCloningUtils.createExceptionOnRead(bean, field, e);
        }
    }

    private static void setFieldValue(Object bean, Field field, double value) {
        try {
            field.setDouble(bean, value);
        }
        catch (IllegalAccessException e) {
            throw FieldCloningUtils.createExceptionOnWrite(bean, field, value, e);
        }
    }

    static void copyObject(FieldHandle handles, Object original, Object clone) {
        Object originalValue = FieldCloningUtils.getObjectFieldValue(original, handles);
        FieldCloningUtils.setObjectFieldValue(clone, handles, originalValue);
    }

    static Object getObjectFieldValue(Object bean, FieldHandle handle) {
        return handle.get(bean);
    }

    private static RuntimeException createExceptionOnRead(Object bean, Field field, Throwable rootCause) {
        return new IllegalStateException("The class (" + String.valueOf(bean.getClass()) + ") has a field (" + String.valueOf(field) + ") which cannot be read to create a planning clone.", rootCause);
    }

    static void setObjectFieldValue(Object bean, FieldHandle handle, Object value) {
        try {
            handle.set(bean, value);
        }
        catch (Throwable e) {
            throw FieldCloningUtils.createExceptionOnWrite(bean, handle.field(), value, e);
        }
    }

    private static RuntimeException createExceptionOnWrite(Object bean, Field field, Object value, Throwable rootCause) {
        return new IllegalStateException("The class (" + String.valueOf(bean.getClass()) + ") has a field (" + String.valueOf(field) + ") which cannot be written with the value (" + String.valueOf(value) + ") to create a planning clone.", rootCause);
    }

    private FieldCloningUtils() {
    }
}

